/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.common.vm.context.managed;

import java.util.OptionalLong;
import java.util.function.Supplier;
import li.cil.oc2.api.bus.device.vm.context.InterruptAllocator;
import li.cil.oc2.api.bus.device.vm.context.MemoryAllocator;
import li.cil.oc2.api.bus.device.vm.context.MemoryRangeAllocator;
import li.cil.oc2.api.bus.device.vm.context.VMContext;
import li.cil.oc2.api.bus.device.vm.context.VMLifecycleEventBus;
import li.cil.oc2.common.vm.context.VMContextManagerCollection;
import li.cil.oc2.common.vm.context.managed.ManagedEventBus;
import li.cil.oc2.common.vm.context.managed.ManagedInterruptAllocator;
import li.cil.oc2.common.vm.context.managed.ManagedInterruptController;
import li.cil.oc2.common.vm.context.managed.ManagedMemoryAllocator;
import li.cil.oc2.common.vm.context.managed.ManagedMemoryMap;
import li.cil.oc2.common.vm.context.managed.ManagedMemoryRangeAllocator;
import li.cil.sedna.api.device.InterruptController;
import li.cil.sedna.api.memory.MemoryMap;

public final class ManagedVMContext
implements VMContext {
    private final VMContext parent;
    private final ManagedMemoryMap memoryMap;
    private final ManagedInterruptController interruptController;
    private final ManagedMemoryRangeAllocator memoryRangeAllocator;
    private final ManagedInterruptAllocator interruptAllocator;
    private final ManagedMemoryAllocator memoryAllocator;
    private final ManagedEventBus eventBus;

    public ManagedVMContext(VMContext parent, VMContextManagerCollection managers, Supplier<OptionalLong> baseAddressSupplier) {
        this.parent = parent;
        this.memoryRangeAllocator = new ManagedMemoryRangeAllocator(parent.getMemoryRangeAllocator(), managers.getMemoryRangeManager(), baseAddressSupplier);
        this.interruptAllocator = new ManagedInterruptAllocator(parent.getInterruptAllocator(), managers.getInterruptManager());
        this.memoryMap = new ManagedMemoryMap(parent.getMemoryMap());
        this.interruptController = new ManagedInterruptController(parent.getInterruptController(), this.interruptAllocator);
        this.memoryAllocator = new ManagedMemoryAllocator();
        this.eventBus = new ManagedEventBus(parent.getEventBus(), managers.getEventManager());
    }

    public void freeze() {
        this.memoryRangeAllocator.freeze();
        this.interruptAllocator.freeze();
        this.memoryAllocator.freeze();
        this.eventBus.freeze();
    }

    public void invalidate() {
        this.memoryMap.invalidate();
        this.memoryRangeAllocator.invalidate();
        this.interruptController.invalidate();
        this.interruptAllocator.invalidate();
        this.memoryAllocator.invalidate();
        this.eventBus.invalidate();
    }

    @Override
    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    @Override
    public InterruptController getInterruptController() {
        return this.interruptController;
    }

    @Override
    public MemoryRangeAllocator getMemoryRangeAllocator() {
        return this.memoryRangeAllocator;
    }

    @Override
    public InterruptAllocator getInterruptAllocator() {
        return this.interruptAllocator;
    }

    @Override
    public MemoryAllocator getMemoryAllocator() {
        return this.memoryAllocator;
    }

    @Override
    public VMLifecycleEventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public void joinWorkerThread() {
        this.parent.joinWorkerThread();
    }
}

