/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.data;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import li.cil.oc2.common.block.Blocks;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public final class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((location, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)location, (LootTable)table));
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return Collections.singletonList(Pair.of(ModBlockLootTables::new, (Object)LootParameterSets.field_216267_h));
    }

    public static final class ModBlockLootTables
    extends BlockLootTables {
        protected void addTables() {
            this.func_218492_c((Block)Blocks.REDSTONE_INTERFACE.get());
            this.func_218492_c((Block)Blocks.NETWORK_CONNECTOR.get());
            this.func_218492_c((Block)Blocks.NETWORK_HUB.get());
            this.func_218492_c((Block)Blocks.DISK_DRIVE.get());
            this.func_218492_c((Block)Blocks.CHARGER.get());
            this.func_218522_a((Block)Blocks.COMPUTER.get(), ModBlockLootTables::droppingWithInventory);
        }

        protected Iterable<Block> getKnownBlocks() {
            return StreamSupport.stream(super.getKnownBlocks().spliterator(), false).filter(block -> Objects.requireNonNull(block.getRegistryName()).func_110624_b().equals("oc2")).filter(block -> block != Blocks.BUS_CABLE.get()).collect(Collectors.toList());
        }

        private static LootTable.Builder droppingWithInventory(Block block) {
            return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216055_a("items", ModBlockLootTables.concat("BlockEntityTag", "items"), CopyNbt.Action.REPLACE).func_216055_a("energy", ModBlockLootTables.concat("BlockEntityTag", "energy"), CopyNbt.Action.REPLACE)))));
        }

        private static String concat(String ... paths) {
            return String.join((CharSequence)".", paths);
        }
    }
}

