/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc2.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.oc2.common.item.Items;
import li.cil.oc2.common.item.crafting.RecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class WrenchRecipeBuilder {
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;

    public WrenchRecipeBuilder(IItemProvider result, int count) {
        this.result = result.func_199767_j();
        this.count = count;
        this.requires((IItemProvider)Items.WRENCH.get());
    }

    public static WrenchRecipeBuilder wrenchRecipe(IItemProvider resultIn) {
        return new WrenchRecipeBuilder(resultIn, 1);
    }

    public static WrenchRecipeBuilder wrenchRecipe(IItemProvider resultIn, int countIn) {
        return new WrenchRecipeBuilder(resultIn, countIn);
    }

    public WrenchRecipeBuilder requires(ITag<Item> tagIn) {
        return this.requires(Ingredient.func_199805_a(tagIn));
    }

    public WrenchRecipeBuilder requires(IItemProvider itemIn) {
        return this.requires(itemIn, 1);
    }

    public WrenchRecipeBuilder requires(IItemProvider itemIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}));
        }
        return this;
    }

    public WrenchRecipeBuilder requires(Ingredient ingredientIn) {
        return this.addIngredient(ingredientIn, 1);
    }

    public WrenchRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredientIn);
        }
        return this;
    }

    public WrenchRecipeBuilder unlockedBy(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.func_200275_a(name, criterionIn);
        return this;
    }

    public WrenchRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumerIn) {
        this.save(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void save(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.save(consumerIn, new ResourceLocation(save));
    }

    public void save(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept(new Result(id, this.result, this.count, this.group == null ? "" : this.group, this.ingredients, this.advancementBuilder, new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final String group;
        private final List<Ingredient> ingredients;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn) {
            this.id = idIn;
            this.result = resultIn;
            this.count = countIn;
            this.group = groupIn;
            this.ingredients = ingredientsIn;
            this.advancementBuilder = advancementBuilderIn;
            this.advancementId = advancementIdIn;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonarray.add(ingredient.func_200304_c());
            }
            json.add("ingredients", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            if (this.count > 1) {
                jsonobject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonobject);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)RecipeSerializers.WRENCH.get();
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

