/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data.gen;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tv.mapper.mapperbase.block.BaseBlocks;
import tv.mapper.mapperbase.block.UpDownBlock;

public class BaseBlockStates
extends BlockStateProvider {
    protected final String mod_id;

    public BaseBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.mod_id = modid;
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)BaseBlocks.STEEL_BLOCK.get());
        this.slabBlock((SlabBlock)BaseBlocks.STEEL_SLAB.get(), this.modLoc("block/steel_block"), this.modLoc("block/steel_slab_side"), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"));
        this.stairsBlock((StairsBlock)BaseBlocks.STEEL_STAIRS.get(), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"), this.modLoc("block/steel_block"));
        this.newWallBlock((WallBlock)BaseBlocks.STEEL_WALL.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_post"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_side"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_wall_side_tall"));
        this.pressurePlateBlock((Block)BaseBlocks.STEEL_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/steel_pressure_plate_down"));
        this.fenceBlock((FenceBlock)BaseBlocks.STEEL_FENCE.get(), this.modLoc("block/steel_block"));
        this.fenceGateBlock((FenceGateBlock)BaseBlocks.STEEL_FENCE_GATE.get(), this.modLoc("block/steel_block"));
        this.simpleBlock((Block)BaseBlocks.CONCRETE.get());
        this.slabBlock((SlabBlock)BaseBlocks.CONCRETE_SLAB.get(), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"));
        this.stairsBlock((StairsBlock)BaseBlocks.CONCRETE_STAIRS.get(), this.modLoc("block/concrete"), this.modLoc("block/concrete"), this.modLoc("block/concrete"));
        this.newWallBlock((WallBlock)BaseBlocks.CONCRETE_WALL.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/concrete_wall_post"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/concrete_wall_side"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/concrete_wall_side_tall"));
        this.pressurePlateBlock((Block)BaseBlocks.CONCRETE_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/concrete_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/concrete_pressure_plate_down"));
        this.fenceBlock((FenceBlock)BaseBlocks.CONCRETE_FENCE.get(), this.modLoc("block/concrete"));
        this.fenceGateBlock((FenceGateBlock)BaseBlocks.CONCRETE_FENCE_GATE.get(), this.modLoc("block/concrete"));
        this.simpleBlock((Block)BaseBlocks.ASPHALT.get());
        this.slabBlock((SlabBlock)BaseBlocks.ASPHALT_SLAB.get(), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"));
        this.stairsBlock((StairsBlock)BaseBlocks.ASPHALT_STAIRS.get(), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"), this.modLoc("block/asphalt"));
        this.pressurePlateBlock((Block)BaseBlocks.ASPHALT_PRESSURE_PLATE.get(), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/asphalt_pressure_plate"), (ModelFile)new ModelFile.UncheckedModelFile("mapperbase:block/asphalt_pressure_plate_down"));
        this.simpleBlock((Block)BaseBlocks.BITUMEN_ORE.get());
        this.simpleBlock((Block)BaseBlocks.BITUMEN_BLOCK.get());
    }

    protected void pressurePlateBlock(Block block, ModelFile plate, ModelFile plate_down) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(plate_down).addModel()).partialState().with((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(plate).addModel();
    }

    protected void upDownBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(model).rotationX(180).addModel()).partialState().with((Property)UpDownBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(model).addModel();
    }

    protected void allRotationBlock(Block block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).modelForState().modelFile(model).rotationX(270).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).modelForState().modelFile(model).rotationX(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).modelForState().modelFile(model).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).modelForState().modelFile(model).rotationY(180).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).modelForState().modelFile(model).rotationY(90).uvLock(true).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).modelForState().modelFile(model).rotationY(270).uvLock(true).addModel();
    }

    protected void buttonBlock(Block block, ModelFile model, ModelFile pressed, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            Boolean powered = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
            return ConfiguredModel.builder().modelFile(powered != false ? pressed : model).rotationX(face == AttachFace.WALL ? 90 : (face == AttachFace.CEILING ? 180 : 0)).rotationY(((int)dir.func_185119_l() + angleOffset) % 360).uvLock(face == AttachFace.WALL).build();
        });
    }

    protected void orientableBlock(Block block, ModelFile model, int angleOffset) {
        this.orientableBlock(block, (BlockState $) -> model, angleOffset);
    }

    protected void orientableBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + angleOffset) % 360).build(), new Property[]{BlockStateProperties.field_208198_y});
    }

    protected void rooftilesStairsBlock(StairsBlock block, ResourceLocation texture) {
        String baseName = block.getRegistryName().toString();
        ModelBuilder stairs = this.models().stairs(baseName, texture, texture, texture);
        ModelBuilder stairsInner = this.models().stairsInner(baseName + "_inner", texture, texture, texture);
        ModelBuilder stairsOuter = this.models().stairsOuter(baseName + "_outer", texture, texture, texture);
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BaseBlockStates.lambda$rooftilesStairsBlock$3((ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter, arg_0), new Property[]{StairsBlock.field_204513_t});
    }

    protected void newWallBlock(WallBlock block, ModelFile post, ModelFile side, ModelFile side_tall) {
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder((Block)block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(post).addModel()).condition((Property)WallBlock.field_176256_a, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).addModel()).condition((Property)WallBlock.field_235613_c_, (Comparable[])new WallHeight[]{WallHeight.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(90).uvLock(true).addModel()).condition((Property)WallBlock.field_235612_b_, (Comparable[])new WallHeight[]{WallHeight.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(180).uvLock(true).addModel()).condition((Property)WallBlock.field_235614_d_, (Comparable[])new WallHeight[]{WallHeight.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(270).uvLock(true).addModel()).condition((Property)WallBlock.field_235615_e_, (Comparable[])new WallHeight[]{WallHeight.LOW}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).addModel()).condition((Property)WallBlock.field_235613_c_, (Comparable[])new WallHeight[]{WallHeight.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(90).uvLock(true).addModel()).condition((Property)WallBlock.field_235612_b_, (Comparable[])new WallHeight[]{WallHeight.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(180).uvLock(true).addModel()).condition((Property)WallBlock.field_235614_d_, (Comparable[])new WallHeight[]{WallHeight.TALL}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side_tall).rotationY(270).uvLock(true).addModel()).condition((Property)WallBlock.field_235615_e_, (Comparable[])new WallHeight[]{WallHeight.TALL}).end();
    }

    protected String getModId() {
        return this.mod_id;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$rooftilesStairsBlock$3(ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
        Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
        StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
        int yRot = (int)facing.func_176746_e().func_185119_l();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(false).build();
    }
}

