/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.data.gen;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import tv.mapper.mapperbase.MapperBase;
import tv.mapper.mapperbase.block.CustomDoorBlock;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(Blocks.field_150380_bt, Blocks.field_150461_bJ, Blocks.field_205165_jY, Blocks.field_196703_eM, Blocks.field_196705_eO, Blocks.field_196710_eS, Blocks.field_196708_eQ, Blocks.field_196714_eU, Blocks.field_196716_eW, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp).map(IItemProvider::func_199767_j).collect(ImmutableSet.toImmutableSet());
    private static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected static <T> T withExplosionDecay(IItemProvider p_218552_0_, ILootFunctionConsumer<T> p_218552_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218552_0_.func_199767_j()) ? p_218552_1_.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : p_218552_1_.func_212862_c_());
    }

    protected static <T> T withSurvivesExplosion(IItemProvider p_218560_0_, ILootConditionConsumer<T> p_218560_1_) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(p_218560_0_.func_199767_j()) ? p_218560_1_.func_212840_b_(SurvivesExplosion.func_215968_b()) : p_218560_1_.func_212862_c_());
    }

    protected LootTable.Builder createStandardTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSlabTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)BaseLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE))))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createDoorTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)CustomDoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER)))).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createBedTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)BedBlock.field_176472_a, (Comparable)BedPart.HEAD)))).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createChestTable(String name, Block block) {
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY))).func_212840_b_(SurvivesExplosion.func_215968_b());
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Block loot) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(SILK_TOUCH)).func_216080_a((LootEntry.Builder)BaseLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)loot))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(SILK_TOUCH)).func_216080_a((LootEntry.Builder)BaseLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)loot))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createSilkTable(String modid, Block block, Item loot, int min, int max, int fortune) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(SILK_TOUCH)).func_216080_a((LootEntry.Builder)BaseLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)loot).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)fortune)))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                MapperBase.LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return "MapperBase LootTables";
    }
}

