/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.battery.EnumBatteryPercent;
import com.lothrazar.cyclic.block.battery.ScreenBattery;
import com.lothrazar.cyclic.block.battery.TileBattery;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockBattery
extends BlockBase {
    public static final EnumProperty<EnumBatteryPercent> PERCENT = EnumProperty.func_177709_a((String)"percent", EnumBatteryPercent.class);

    public BlockBattery(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.8f));
        this.setHasGui();
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(PERCENT, (Comparable)((Object)EnumBatteryPercent.ZERO)));
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.batteryCont, ScreenBattery::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{PERCENT});
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity ent, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, ent, stack);
        ItemStack battery = new ItemStack((IItemProvider)this);
        if (ent != null) {
            IEnergyStorage handlerHere = (IEnergyStorage)ent.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            IEnergyStorage storage = (IEnergyStorage)battery.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage instanceof CustomEnergyStorage) {
                ((CustomEnergyStorage)storage).setEnergy(handlerHere.getEnergyStored());
            } else {
                storage.receiveEnergy(handlerHere.getEnergyStored(), false);
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), battery));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileBattery();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int current = 0;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy")) {
            current = stack.func_77978_p().func_74762_e("energy");
        } else if (storage != null) {
            current = storage.getEnergyStored();
        }
        TileBattery container = (TileBattery)world.func_175625_s(pos);
        CustomEnergyStorage storageTile = (CustomEnergyStorage)((Object)container.getCapability(CapabilityEnergy.ENERGY, null).orElse(null));
        if (storageTile != null) {
            storageTile.setEnergy(current);
        }
    }
}

