/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.capability.EnergyCapabilityItemStack;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBlockBattery
extends BlockItem {
    public ItemBlockBattery(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy");
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xBC000C;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int current = 0;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy")) {
            current = stack.func_77978_p().func_74762_e("energy");
        } else if (storage != null) {
            current = storage.getEnergyStored();
        }
        tooltip.add((ITextComponent)new TranslationTextComponent(current + "/" + 6400000).func_240699_a_(TextFormatting.RED));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double current = 0.0;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy")) {
            current = stack.func_77978_p().func_74762_e("energy");
        } else if (storage != null) {
            current = storage.getEnergyStored();
        }
        double max = 6400000.0;
        return 1.0 - current / max;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new EnergyCapabilityItemStack(stack, 6400000);
    }
}

