/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.item.ContainerCableItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableItem
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int FLOW_QTY = 64;
    private int extractQty = 64;
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    private Map<Direction, LazyOptional<IItemHandler>> flow = Maps.newHashMap();
    List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCableItem() {
        super(TileRegistry.item_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<IItemHandler>)LazyOptional.of(TileCableItem::createHandler));
        }
    }

    private static ItemStackHandler createHandler() {
        return new ItemStackHandler(1);
    }

    public void func_73660_a() {
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(extractSide)));
            if (!connection.isExtraction()) continue;
            IItemHandler sideHandler = (IItemHandler)this.flow.get(extractSide).orElse(null);
            this.tryExtract(sideHandler, extractSide, this.extractQty, this.filter);
        }
        this.normalFlow();
    }

    private void normalFlow() {
        for (Direction incomingSide : Direction.values()) {
            IItemHandler sideHandler = (IItemHandler)this.flow.get(incomingSide).orElse(null);
            Collections.shuffle(this.rawList);
            boolean validAdjacent = false;
            for (Integer i : this.rawList) {
                EnumConnectType connection;
                Direction outgoingSide = Direction.values()[i];
                if (outgoingSide == incomingSide || (connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)))).isExtraction() || connection.isBlocked()) continue;
                validAdjacent = validAdjacent || this.moveItems(outgoingSide, 64, sideHandler);
            }
            if (validAdjacent) continue;
            this.moveItems(incomingSide, 64, sideHandler);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.extractQty = tag.func_74762_e("extractCount");
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT itemTag = tag.func_74775_l("item" + f.toString());
                ((INBTSerializable)h).deserializeNBT((INBT)itemTag);
            });
        }
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_74768_a("extractCount", this.extractQty);
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
                tag.func_218657_a("item" + f.toString(), (INBT)compound);
            });
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        this.extractQty = value;
    }

    @Override
    public int getField(int field) {
        return this.extractQty;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableItem(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

