/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.generatorfluid.ContainerGeneratorFluid;
import com.lothrazar.cyclic.block.generatorfluid.RecipeGeneratorFluid;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.capability.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGeneratorFluid
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static final int CAPACITY = 64000;
    static final int MAX = 640000;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 640000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(0);
    protected final FluidTankBase tank = new FluidTankBase(this, 64000, p -> true);
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    ItemStackHandler outputSlots = new ItemStackHandler(0);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int burnTimeMax = 0;
    private int burnTime = 0;
    private RecipeGeneratorFluid<?> currentRecipe;

    public TileGeneratorFluid() {
        super((TileEntityType)TileRegistry.GENERATOR_FLUID.get());
        this.needsRedstone = 0;
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.flowing == 1) {
            this.exportEnergyAllSides();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.burnTime <= 0) {
            this.currentRecipe = null;
            this.burnTimeMax = 0;
            this.burnTime = 0;
        }
        this.tryConsumeFuel();
    }

    private void tryConsumeFuel() {
        if (this.burnTime > 0 && this.energy.getEnergyStored() + this.currentRecipe.getRfpertick() <= this.energy.getMaxEnergyStored()) {
            this.setLitProperty(true);
            --this.burnTime;
            this.energy.receiveEnergy(this.currentRecipe.getRfpertick(), false);
        } else if (this.burnTime <= 0) {
            this.findMatchingRecipe();
            if (this.currentRecipe == null) {
                this.burnTime = 0;
                return;
            }
        }
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.field_145850_b)) {
            return;
        }
        this.currentRecipe = null;
        List recipes = this.field_145850_b.func_199532_z().func_241447_a_(CyclicRecipeType.GENERATOR_FLUID);
        for (RecipeGeneratorFluid rec : recipes) {
            if (!rec.matches(this, this.field_145850_b)) continue;
            this.currentRecipe = rec;
            this.burnTime = this.burnTimeMax = this.currentRecipe.getTicks();
            this.tank.drain(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerGeneratorFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
                break;
            }
            case FLOWING: {
                this.flowing = value;
            }
        }
    }

    public int getEnergyMax() {
        return 640000;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        BURNMAX,
        FLOWING;

    }
}

