/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.laser;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.laser.TileLaser;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class RenderLaser
extends TileEntityRenderer<TileLaser> {
    public RenderLaser(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(TileLaser te, float v, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int partialTicks, int destroyStage) {
        if (te.requiresRedstone() && !te.isPowered()) {
            return;
        }
        try {
            RenderLaser.draw(te, matrixStack, iRenderTypeBuffer);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("RenderLaser.java ", e);
        }
    }

    private static Vector3f adjustBeamToEyes(Vector3f from, Vector3f to, BlockPos tile) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vector3f vectP = new Vector3f((float)player.func_226277_ct_() - (float)tile.func_177958_n(), (float)player.func_226280_cw_() - (float)tile.func_177956_o(), (float)player.func_226281_cx_() - (float)tile.func_177952_p());
        Vector3f vectS = from.func_229195_e_();
        vectS.func_195897_a(vectP);
        Vector3f vectE = to.func_229195_e_();
        vectE.func_195897_a(from);
        Vector3f adjustedVec = vectS.func_229195_e_();
        adjustedVec.func_195896_c(vectE);
        adjustedVec.func_229194_d_();
        return adjustedVec;
    }

    public static void draw(TileLaser tile, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) throws Exception {
        BlockPos posTarget = tile.getPosTarget();
        if (posTarget == null || posTarget.equals((Object)BlockPos.field_177992_a)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        Matrix4f positionMatrix = matrixStackIn.func_227866_c_().func_227870_a_();
        BlockPos tilePos = tile.func_174877_v();
        Vector3f from = new Vector3f((float)posTarget.func_177958_n() + 0.5f - (float)tilePos.func_177958_n(), (float)posTarget.func_177956_o() + 0.5f - (float)tilePos.func_177956_o(), (float)posTarget.func_177952_p() + 0.5f - (float)tilePos.func_177952_p());
        Vector3f to = new Vector3f(tile.xOffset.getOffset(), tile.yOffset.getOffset(), tile.zOffset.getOffset());
        IVertexBuilder builder = bufferIn.getBuffer(FakeBlockRenderTypes.LASER_MAIN_BEAM);
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, tile.getRed(), tile.getGreen(), tile.getBlue(), tile.getAlpha(), tile.getThick(), tilePos);
        float coreThick = 0.01f;
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, 1.0f, 1.0f, 1.0f, tile.getAlpha(), 0.01f, tilePos);
        matrixStackIn.func_227865_b_();
    }

    public static void drawDirewolfLaser(IVertexBuilder builder, Matrix4f positionMatrix, Vector3f from, Vector3f to, float r, float g, float b, float alpha, float thickness, BlockPos tilePos) {
        float v = 1.0f;
        Vector3f adjustedVec = RenderLaser.adjustBeamToEyes(from, to, tilePos);
        adjustedVec.func_195898_a(thickness);
        Vector3f p1 = from.func_229195_e_();
        p1.func_229189_a_(adjustedVec);
        Vector3f p2 = from.func_229195_e_();
        p2.func_195897_a(adjustedVec);
        Vector3f p3 = to.func_229195_e_();
        p3.func_229189_a_(adjustedVec);
        Vector3f p4 = to.func_229195_e_();
        p4.func_195897_a(adjustedVec);
        builder.func_227888_a_(positionMatrix, p1.func_195899_a(), p1.func_195900_b(), p1.func_195902_c()).func_227885_a_(r, g, b, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(positionMatrix, p3.func_195899_a(), p3.func_195900_b(), p3.func_195902_c()).func_227885_a_(r, g, b, alpha).func_225583_a_(1.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(positionMatrix, p4.func_195899_a(), p4.func_195900_b(), p4.func_195902_c()).func_227885_a_(r, g, b, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(positionMatrix, p2.func_195899_a(), p2.func_195900_b(), p2.func_195902_c()).func_227885_a_(r, g, b, alpha).func_225583_a_(0.0f, 1.0f).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_181675_d();
    }

    public boolean isGlobalRenderer(TileLaser te) {
        return true;
    }
}

