/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSolidifier<TileEntityBase>
extends CyclicRecipe {
    private ItemStack result = ItemStack.field_190927_a;
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack fluidInput;
    public static final SerializeSolidifier SERIALIZER = new SerializeSolidifier();

    public RecipeSolidifier(ResourceLocation id, Ingredient in, Ingredient inSecond, Ingredient inThird, FluidStack fluid, ItemStack result) {
        super(id);
        this.result = result;
        this.fluidInput = fluid;
        this.ingredients.add((Object)in);
        this.ingredients.add((Object)inSecond);
        this.ingredients.add((Object)inThird);
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileSolidifier tile = (TileSolidifier)inv;
            return this.matchItems(tile) && this.matchFluid(tile.getFluid());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private int findMatchingSlot(TileSolidifier tile, Ingredient shapeless, List<Integer> skip) {
        for (int i = 0; i < 3; ++i) {
            if (skip.contains(i) || !shapeless.test(tile.getStackInputSlot(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean matchItems(TileSolidifier tile) {
        Ingredient top = (Ingredient)this.ingredients.get(0);
        Ingredient middle = (Ingredient)this.ingredients.get(1);
        Ingredient bottom = (Ingredient)this.ingredients.get(2);
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        matchingSlots.add(this.findMatchingSlot(tile, top, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, middle, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, bottom, matchingSlots));
        if (matchingSlots.contains(-1)) {
            return false;
        }
        return matchingSlots.contains(0) && matchingSlots.contains(1) && matchingSlots.contains(2);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidInput.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.SOLID;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class SerializeSolidifier
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeSolidifier<? extends TileEntityBase>> {
        SerializeSolidifier() {
            this.setRegistryName(new ResourceLocation("cyclic", "solidifier"));
        }

        public RecipeSolidifier<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeSolidifier r = null;
            try {
                Ingredient inputTop = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputTop"));
                Ingredient inputMiddle = Ingredient.field_193370_a;
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"inputMiddle")) {
                    inputMiddle = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputMiddle"));
                }
                Ingredient inputBottom = Ingredient.field_193370_a;
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"inputBottom")) {
                    inputBottom = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"inputBottom"));
                }
                ItemStack resultStack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
                if (inputTop == Ingredient.field_193370_a) {
                    throw new IllegalArgumentException("Invalid items: inputTop required to be non-empty: " + json);
                }
                FluidStack fs = CyclicRecipe.getFluid(json, "mix");
                r = new RecipeSolidifier(recipeId, inputTop, inputMiddle, inputBottom, fs, resultStack);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            ModCyclic.LOGGER.info("Recipe loaded " + recipeId);
            return r;
        }

        public RecipeSolidifier read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeSolidifier r = new RecipeSolidifier(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer), FluidStack.readFromPacket((PacketBuffer)buffer), buffer.func_150791_c());
            return r;
        }

        public void write(PacketBuffer buffer, RecipeSolidifier recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            Ingredient two = (Ingredient)recipe.ingredients.get(2);
            zero.func_199564_a(buffer);
            one.func_199564_a(buffer);
            two.func_199564_a(buffer);
            recipe.fluidInput.writeToPacket(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

