/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundmuff;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.soundmuff.SoundVolumeControlled;
import com.lothrazar.cyclic.util.UtilBlockstates;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundmufflerBlock
extends BlockBase {
    private static final int VOL_REDUCE_PER_BLOCK = 2;
    private static final int RADIUS = 6;

    public SoundmufflerBlock(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.0f).func_200947_a(SoundType.field_222470_q));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        if (event.getResultSound() == null || event.getResultSound() instanceof ITickableSound || clientWorld == null) {
            return;
        }
        ISound sound = event.getResultSound();
        ArrayList<BlockPos> blocks = UtilBlockstates.findBlocks((World)clientWorld, new BlockPos(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()), this, 6);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            float pct = 0.33333334f;
            newSound.setVolume((float)(Math.min((double)pct, 1.0) / (double)blocks.size()));
            event.setResultSound((ISound)newSound);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error trying to detect volume of sound from 3rd party ", e);
        }
    }
}

