/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapabilityItemStack
implements ICapabilityProvider {
    public static final String NBTENERGY = "energy";
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private int max;
    private ItemStack stack;

    public EnergyCapabilityItemStack(ItemStack stack, int capacity) {
        this.max = capacity;
        this.stack = stack;
        this.energy = LazyOptional.of(this::createEnergy);
    }

    private IEnergyStorage createEnergy() {
        return new EnergyStorage(this.max, this.max){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int r = super.receiveEnergy(maxReceive, simulate);
                this.syncEnergy();
                return r;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int r = super.extractEnergy(maxExtract, simulate);
                this.syncEnergy();
                return r;
            }

            private void syncEnergy() {
                if (!EnergyCapabilityItemStack.this.stack.func_77942_o()) {
                    EnergyCapabilityItemStack.this.stack.func_77982_d(new CompoundNBT());
                }
                EnergyCapabilityItemStack.this.stack.func_77978_p().func_74768_a(EnergyCapabilityItemStack.NBTENERGY, this.getEnergyStored());
            }
        };
    }

    public String toString() {
        return "EnergyCapabilityItemStack [energy=" + this.energy + ", stack=" + this.stack + "]";
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CapabilityEnergy.ENERGY == capability) {
            return this.energy.cast();
        }
        return LazyOptional.empty();
    }
}

