/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantPearl
extends EnchantBase {
    private static final int COOLDOWN = 120;
    private static final float VELOCITY = 1.5f;
    private static final float INNACCURACY = 1.0f;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "ender";

    public EnchantPearl(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        return stack.func_77973_b() instanceof SwordItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        int level;
        World world = event.getWorld();
        if (!world.field_72995_K && event.getResult() != Event.Result.DENY && (level = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)event.getItemStack())) > 0) {
            int adjustedCooldown = 120 / level;
            PlayerEntity player = event.getPlayer();
            if (player.func_184811_cZ().func_185141_a(event.getItemStack().func_77973_b())) {
                return;
            }
            EnderPearlEntity pearl = new EnderPearlEntity(world, (LivingEntity)player);
            Vector3d lookVector = player.func_70040_Z();
            pearl.func_70186_c(lookVector.func_82615_a(), lookVector.func_82617_b(), lookVector.func_82616_c(), 1.5f, 1.0f);
            UtilEntity.setCooldownItem(player, event.getItemStack().func_77973_b(), adjustedCooldown);
            UtilSound.playSound((Entity)player, SoundEvents.field_187595_bc, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
            world.func_217376_c((Entity)pearl);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }
}

