/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.ItemEntityInteractable;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.scaffolding.ItemScaffolding;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.enchant.EnchantMultishot;
import com.lothrazar.cyclic.item.AntimatterEvaporatorWandItem;
import com.lothrazar.cyclic.item.apple.LoftyStatureApple;
import com.lothrazar.cyclic.item.bauble.CharmBase;
import com.lothrazar.cyclic.item.bauble.SoulstoneCharm;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.carrot.ItemHorseEnder;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.enderbook.EnderBookItem;
import com.lothrazar.cyclic.item.heart.HeartItem;
import com.lothrazar.cyclic.item.storagebag.ItemStorageBag;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.PotionRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.CharmUtil;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemEvents {
    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (player.func_184614_ca().func_77973_b() == ItemRegistry.ENDER_BOOK.get()) {
            EnderBookItem.cancelTeleport(player.func_184614_ca());
        }
        if (player.func_184592_cb().func_77973_b() == ItemRegistry.ENDER_BOOK.get()) {
            EnderBookItem.cancelTeleport(player.func_184592_cb());
        }
    }

    @SubscribeEvent
    public void onCriticalHitEvent(CriticalHitEvent event) {
        PlayerEntity ply;
        ItemStack find;
        if (event.getEntityLiving() instanceof PlayerEntity && !(find = CharmUtil.getIfEnabled(ply = (PlayerEntity)event.getEntityLiving(), (Item)ItemRegistry.CHARM_CRIT.get())).func_190926_b()) {
            event.setDamageModifier(3.0f);
            UtilItemStack.damageItem((LivingEntity)ply, find);
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent event) {
        ItemStack stackBow = event.getBow();
        PlayerEntity player = event.getPlayer();
        World worldIn = player.field_70170_p;
        if (!worldIn.field_72995_K) {
            int level = EnchantRegistry.MULTIBOW.getCurrentLevelTool(stackBow);
            if (level <= 0) {
                return;
            }
            Vector3d playerDirection = UtilEntity.lookVector(player.field_70177_z, player.field_70125_A);
            Vector3d left = playerDirection.func_72431_c(new Vector3d(0.0, 1.0, 0.0));
            Vector3d right = playerDirection.func_72431_c(new Vector3d(0.0, -1.0, 0.0));
            EnchantMultishot.spawnArrow(worldIn, player, stackBow, event.getCharge(), left.func_72432_b());
            EnchantMultishot.spawnArrow(worldIn, player, stackBow, event.getCharge(), right.func_72432_b());
        }
    }

    @SubscribeEvent
    public void onLivingKnockBackEvent(LivingKnockBackEvent event) {
        PlayerEntity ply;
        ItemStack find;
        if (event.getEntityLiving() instanceof PlayerEntity && !(find = CharmUtil.getIfEnabled(ply = (PlayerEntity)event.getEntityLiving(), (Item)ItemRegistry.CHARM_KNOCKBACK_RESIST.get())).func_190926_b()) {
            event.setCanceled(true);
            UtilItemStack.damageItem((LivingEntity)ply, find);
        }
        if (event.getEntityLiving() instanceof FakePlayer) {
            ModCyclic.LOGGER.info("KB fake" + event.getEntityLiving().func_145748_c_().getString());
        }
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent.Arrow event) {
        if (event.getArrow() == null || event.getRayTraceResult() == null) {
            return;
        }
        World world = event.getArrow().field_70170_p;
        RayTraceResult.Type hit = event.getRayTraceResult().func_216346_c();
        Entity shooter = event.getArrow().func_234616_v_();
        if (shooter instanceof PlayerEntity) {
            PlayerEntity ply = (PlayerEntity)shooter;
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.QUIVER_DMG.get());
            if (!find.func_190926_b()) {
                AbstractArrowEntity arrow = event.getArrow();
                double boost = arrow.func_70242_d() / 2.0;
                arrow.func_70239_b(arrow.func_70242_d() + boost);
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.QUIVER_LIT.get())).func_190926_b() && world.field_73012_v.nextDouble() < 0.25 && hit == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
                target.func_184195_f(true);
                BlockPos p = target.func_233580_cy_();
                LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
                lightningboltentity.func_225653_b_((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
                world.func_217376_c((Entity)lightningboltentity);
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
        }
    }

    @SubscribeEvent
    public void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity ply = (PlayerEntity)event.getEntityLiving();
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_ANTIPOTION.get());
            if (!find.func_190926_b()) {
                event.getPotionEffect().field_76460_b = 0;
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_STEALTHPOTION.get())).func_190926_b()) {
                if (event.getOldPotionEffect() != null) {
                    event.getOldPotionEffect().field_188421_h = false;
                }
                event.getPotionEffect().field_188421_h = false;
            }
            if (!(find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_BOOSTPOTION.get())).func_190926_b()) {
                int boost = event.getPotionEffect().field_76460_b / 2;
                event.getPotionEffect().field_76460_b += boost;
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingDamageEvent event) {
        DamageSource src = event.getSource();
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (src.func_94541_c()) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_CREEPER.get(), 0.0f);
            }
            if (src == DamageSource.field_76379_h || src == DamageSource.field_76367_g || src == DamageSource.field_220302_v) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_LONGFALL.get(), 0.0f);
            } else if (src == DamageSource.field_188406_j || src == DamageSource.field_76368_d) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_STONE.get(), 0.0f);
            } else if (src == DamageSource.field_76376_m || src == DamageSource.field_188407_q) {
                this.damageFinder(event, player, (Item)ItemRegistry.CHARM_MAGICDEF.get(), 0.5f);
            } else if (src == DamageSource.field_76366_f) {
                if (this.damageFinder(event, player, (Item)ItemRegistry.CHARM_STARVATION.get(), 0.0f)) {
                    player.func_71024_bL().func_75122_a(0, 0.2f);
                }
            } else if (src == DamageSource.field_76369_e) {
                if (this.damageFinder(event, player, (Item)ItemRegistry.CHARM_WATER.get(), 0.0f)) {
                    EffectInstance eff = new EffectInstance(Effects.field_76427_o, 200, 1);
                    eff.field_188421_h = false;
                    eff.field_205349_i = false;
                    player.func_195064_c(eff);
                }
            } else if (src == DamageSource.field_76371_c || src == DamageSource.field_76372_a || src == DamageSource.field_76370_b) {
                this.damageFinder(event, player, ItemRegistry.charm_fire, 0.0f);
            }
        } else if (src.func_76346_g() instanceof PlayerEntity) {
            PlayerEntity ply = (PlayerEntity)src.func_76346_g();
            ItemStack find = CharmUtil.getIfEnabled(ply, (Item)ItemRegistry.CHARM_VENOM.get());
            if (!find.func_190926_b() && ply.field_70170_p.field_73012_v.nextDouble() < 0.25) {
                int seconds = 2 + ply.field_70170_p.field_73012_v.nextInt(4);
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76436_u, 20 * seconds, 0));
                UtilItemStack.damageItem((LivingEntity)ply, find);
            }
            if (ply.func_184600_cs() == null || ply.func_184586_b(ply.func_184600_cs()).func_190926_b()) {
                // empty if block
            }
        }
    }

    private boolean damageFinder(LivingDamageEvent event, PlayerEntity player, Item item, float factor) {
        ItemStack find = CharmUtil.getIfEnabled(player, item);
        if (!find.func_190926_b()) {
            float amt = event.getAmount() * factor;
            event.setAmount(amt);
            if (amt <= 0.0f) {
                event.setCanceled(true);
            }
            UtilItemStack.damageItem((LivingEntity)player, find);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.SOULSTONE.get());
            if (SoulstoneCharm.checkTotemDeathProtection(event.getSource(), player, charmStack)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloneDeath(PlayerEvent.Clone event) {
        AttributeModifier healthModifier;
        ModifiableAttributeInstance original = event.getOriginal().func_110148_a(Attributes.field_233818_a_);
        if (original != null && (healthModifier = original.func_111127_a(HeartItem.ID)) != null) {
            event.getPlayer().func_110148_a(Attributes.field_233818_a_).func_233769_c_(healthModifier);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity liv = event.getEntityLiving();
        this.tryItemHorseEnder(liv);
        if (liv instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)liv;
            CharmBase.charmSpeed(player);
            CharmBase.charmLuck(player);
            CharmBase.charmAttackSpeed(player);
            CharmBase.charmExpSpeed(player);
            LoftyStatureApple.onUpdate(player);
        }
    }

    @SubscribeEvent
    public void onXpPickup(PlayerXpEvent.PickupXp event) {
        PlayerEntity player = event.getPlayer();
        ItemStack charmStack = CharmUtil.getIfEnabled(player, (Item)ItemRegistry.CHARM_XPSTOPPER.get());
        if (!charmStack.func_190926_b()) {
            event.setCanceled(true);
        }
    }

    private void tryItemHorseEnder(LivingEntity liv) {
        if (liv.getPersistentData().func_74764_b("cyclic_carrot_ender") && liv.getPersistentData().func_74762_e("cyclic_carrot_ender") > 0) {
            if (liv.func_70090_H() && !liv.func_70648_aU() && liv.func_70086_ai() < liv.func_205010_bg() && !liv.func_70644_a(Effects.field_76427_o)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76427_o, 1200, 4));
                liv.func_195064_c(new EffectInstance((Effect)PotionRegistry.PotionEffects.swimspeed, 1200, 1));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.func_70027_ad() && !liv.func_70644_a(Effects.field_76426_n)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76426_n, 1200, 4));
                liv.func_70066_B();
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.field_70143_R > 12.0f && !liv.func_70644_a(Effects.field_204839_B)) {
                liv.func_195064_c(new EffectInstance(Effects.field_204839_B, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
            if (liv.func_110143_aJ() < 6.0f && !liv.func_70644_a(Effects.field_76444_x)) {
                liv.func_195064_c(new EffectInstance(Effects.field_76444_x, 1200, 4));
                liv.func_195064_c(new EffectInstance(Effects.field_76429_m, 1200, 4));
                ItemHorseEnder.onSuccess(liv);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() == Blocks.field_196661_l && world.func_175623_d(pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), ((Block)BlockRegistry.FLOWER_CYAN.get()).func_176223_P());
            event.setResult(Event.Result.ALLOW);
        } else if (world.func_180495_p(pos).func_177230_c() == BlockRegistry.FLOWER_CYAN.get()) {
            event.setResult(Event.Result.ALLOW);
            if (world.field_73012_v.nextDouble() < 0.5) {
                UtilItemStack.drop(world, pos, new ItemStack((IItemProvider)BlockRegistry.FLOWER_CYAN.get()));
            }
        }
    }

    @SubscribeEvent
    public void onBedCheck(SleepingLocationCheckEvent event) {
        PlayerEntity p;
        if (event.getEntity() instanceof PlayerEntity && (p = (PlayerEntity)event.getEntity()).getPersistentData().func_74767_n("cyclic_sleeping")) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemScaffolding && event.getPlayer().func_213453_ef()) {
            this.scaffoldHit(event);
        }
        if (event.getPlayer().func_213453_ef() && event.getItemStack().func_77973_b().func_206844_a(DataTags.WRENCH) && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof CableBase) {
            event.getPlayer().func_184609_a(event.getHand());
            event.getWorld().func_175655_b(event.getPos(), true);
            event.setCanceled(true);
        }
    }

    private void scaffoldHit(PlayerInteractEvent.RightClickBlock event) {
        ItemScaffolding item = (ItemScaffolding)event.getItemStack().func_77973_b();
        Direction opp = event.getFace().func_176734_d();
        BlockPos dest = UtilWorld.nextReplaceableInDirection(event.getWorld(), event.getPos(), opp, 16, item.func_179223_d());
        if (event.getWorld().func_175623_d(dest)) {
            event.getWorld().func_175656_a(dest, item.func_179223_d().func_176223_P());
            ItemStack stac = event.getPlayer().func_184586_b(event.getHand());
            UtilItemStack.shrink(event.getPlayer(), stac);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() instanceof ItemEntityInteractable) {
            ItemEntityInteractable item = (ItemEntityInteractable)event.getItemStack().func_77973_b();
            item.interactWith(event);
        }
    }

    @SubscribeEvent
    public void onHit(PlayerInteractEvent.LeftClickBlock event) {
        BlockState target;
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (held.func_190926_b()) {
            return;
        }
        World world = player.func_130014_f_();
        if (held.func_77973_b() instanceof ShapeCard && player.func_213453_ef()) {
            target = world.func_180495_p(event.getPos());
            ShapeCard.setBlockState(held, target);
            UtilChat.sendStatusMessage(player, target.func_177230_c().func_149739_a());
        }
        if (held.func_77973_b() instanceof BuilderItem) {
            if (BuilderActionType.getTimeout(held) > 0) {
                return;
            }
            BuilderActionType.setTimeout(held);
            event.setCanceled(true);
            if (player.func_213453_ef()) {
                target = world.func_180495_p(event.getPos());
                BuilderActionType.setBlockState(held, target);
                UtilChat.sendStatusMessage(player, target.func_177230_c().func_149739_a());
                event.setCanceled(true);
                UtilSound.playSound((Entity)player, SoundRegistry.DCOIN, 0.3f, 1.0f);
            } else {
                if (!world.field_72995_K) {
                    BuilderActionType.toggle(held);
                }
                UtilSound.playSound((Entity)player, SoundRegistry.TOOL_MODE);
                UtilChat.sendStatusMessage(player, UtilChat.lang(BuilderActionType.getName(held)));
                event.setCanceled(true);
            }
        }
        if (held.func_77973_b() instanceof AntimatterEvaporatorWandItem) {
            AntimatterEvaporatorWandItem.toggleMode(player, held);
        }
    }

    @SubscribeEvent
    public void onPlayerPickup(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemEntity itemEntity = event.getItem();
            ItemStack resultStack = itemEntity.func_92059_d();
            int origCount = resultStack.func_190916_E();
            for (Integer i : ItemStorageBag.getAllBagSlots(player)) {
                ItemStack bag = player.field_71071_by.func_70301_a(i.intValue());
                switch (ItemStorageBag.getPickupMode(bag)) {
                    case EVERYTHING: {
                        resultStack = ItemStorageBag.tryInsert(bag, resultStack);
                        break;
                    }
                    case FILTER: {
                        resultStack = ItemStorageBag.tryFilteredInsert(bag, resultStack);
                        break;
                    }
                }
                if (!resultStack.func_190926_b()) continue;
                break;
            }
            if (resultStack.func_190916_E() != origCount) {
                itemEntity.func_92058_a(resultStack);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

