/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.wing;

import com.lothrazar.cyclic.base.IHasClickToggle;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EnderWingItem
extends ItemBase
implements IHasClickToggle {
    private static final int COOLDOWN = 600;

    public EnderWingItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K || playerIn.func_184811_cZ().func_185141_a((Item)this)) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        this.attemptTeleport(worldIn, playerIn, playerIn.func_184586_b(handIn));
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private void attemptTeleport(World worldIn, PlayerEntity playerIn, ItemStack held) {
        BlockPos respawnPos;
        ServerPlayerEntity serverPlayerEntity;
        ServerWorld serverWorld = worldIn.func_73046_m().func_71218_a(World.field_234918_g_);
        ServerPlayerEntity serverPlayerEntity2 = serverPlayerEntity = playerIn instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerIn : null;
        if (serverWorld != null && serverPlayerEntity != null && (respawnPos = serverPlayerEntity.func_241140_K_()) != null) {
            Optional optional = PlayerEntity.func_242374_a((ServerWorld)serverWorld, (BlockPos)respawnPos, (float)0.0f, (boolean)true, (boolean)true);
            boolean needsTeleport = false;
            if (optional.isPresent()) {
                BlockPos pos = new BlockPos(((Vector3d)optional.get()).func_82615_a(), ((Vector3d)optional.get()).func_82617_b(), ((Vector3d)optional.get()).func_82616_c());
                RegistryKey spawnWorldKey = serverPlayerEntity.func_241141_L_();
                ServerWorld spawnWorld = worldIn.func_73046_m().func_71218_a(spawnWorldKey);
                if (spawnWorld != null && spawnWorldKey == World.field_234919_h_) {
                    if (worldIn.func_234923_W_() == World.field_234919_h_) {
                        needsTeleport = true;
                    } else {
                        UtilChat.sendStatusMessage(playerIn, "command.cyclic.home.nether");
                    }
                } else if (spawnWorld != null && spawnWorldKey == World.field_234918_g_) {
                    if (worldIn.func_234923_W_() == World.field_234918_g_) {
                        needsTeleport = true;
                    } else {
                        UtilChat.sendStatusMessage(playerIn, "command.cyclic.home.overworld");
                    }
                }
                if (needsTeleport) {
                    UtilItemStack.damageItem((LivingEntity)playerIn, held);
                    playerIn.func_184811_cZ().func_185145_a((Item)this, 600);
                    UtilEntity.enderTeleportEvent((LivingEntity)playerIn, (World)spawnWorld, pos);
                    UtilSound.playSound((Entity)playerIn, SoundRegistry.WARP_ECHO);
                }
            } else {
                UtilChat.sendStatusMessage(playerIn, "command.cyclic.home.obstructed");
            }
        }
    }

    @Override
    public void toggle(PlayerEntity player, ItemStack held) {
        this.attemptTeleport(player.field_70170_p, player, held);
    }

    @Override
    public boolean isOn(ItemStack held) {
        return false;
    }
}

