/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.block.enderitemshelf.ClientAutoSyncItemHandler;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class PacketTileInventoryToClient
extends PacketBase {
    private BlockPos blockPos;
    private int slot;
    private ItemStack itemStack;
    private SyncPacketType type;

    public PacketTileInventoryToClient(BlockPos blockPos, int slot, ItemStack itemStack, SyncPacketType type) {
        this.blockPos = blockPos;
        this.slot = slot;
        this.itemStack = itemStack;
        this.type = type;
    }

    public PacketTileInventoryToClient() {
    }

    public static void handle(PacketTileInventoryToClient message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                message.done(ctx);
                return;
            }
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.blockPos);
            if (tile != null) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    if (message.type == SyncPacketType.SET) {
                        if (h instanceof EnderShelfItemHandler) {
                            ItemStack itemStack = ((EnderShelfItemHandler)((Object)((Object)h))).emptySlot(message.slot);
                        } else if (h instanceof ClientAutoSyncItemHandler) {
                            ItemStack itemStack = ((ClientAutoSyncItemHandler)((Object)((Object)h))).emptySlot(message.slot);
                        } else {
                            h.extractItem(message.slot, 64, false);
                        }
                    }
                    h.insertItem(message.slot, message.itemStack, false);
                });
            }
        });
        message.done(ctx);
    }

    public static PacketTileInventoryToClient decode(PacketBuffer buf) {
        PacketTileInventoryToClient p = new PacketTileInventoryToClient();
        p.blockPos = buf.func_179259_c();
        p.slot = buf.readInt();
        p.itemStack = buf.func_150791_c();
        p.type = (SyncPacketType)buf.func_179257_a(SyncPacketType.class);
        return p;
    }

    public static void encode(PacketTileInventoryToClient msg, PacketBuffer buf) {
        buf.func_179255_a(msg.blockPos);
        buf.writeInt(msg.slot);
        buf.func_150788_a(msg.itemStack);
        buf.func_179249_a((Enum)msg.type);
    }

    public static enum SyncPacketType {
        CHANGE,
        SET;

    }
}

