/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.recipe;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.base.TileEntityBase;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CyclicRecipe
implements IRecipe<TileEntityBase> {
    private final ResourceLocation id;

    protected CyclicRecipe(ResourceLocation id) {
        this.id = id;
    }

    public ItemStack getCraftingResult(TileEntityBase inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public FluidStack getRecipeFluid() {
        return FluidStack.EMPTY;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }

    public boolean matchFluid(FluidStack tileFluid) {
        if (tileFluid == null || tileFluid.isEmpty()) {
            return false;
        }
        if (tileFluid.getFluid() == this.getRecipeFluid().getFluid()) {
            return true;
        }
        for (ITag.INamedTag fluidTag : FluidTags.func_241280_c_()) {
            if (!this.getRecipeFluid().getFluid().func_207185_a((ITag)fluidTag) || !tileFluid.getFluid().func_207185_a((ITag)fluidTag)) continue;
            return true;
        }
        return false;
    }

    public static FluidStack getFluid(JsonObject json, String key) {
        JsonObject mix = json.get(key).getAsJsonObject();
        int count = mix.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        FluidStack fs = null;
        String fluidId = JSONUtils.func_151200_h((JsonObject)mix, (String)"fluid");
        ResourceLocation resourceLocation = new ResourceLocation(fluidId);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        if (fluid == FluidStack.EMPTY.getFluid()) {
            throw new IllegalArgumentException("Invalid fluid specified " + fluidId);
        }
        fs = new FluidStack(fluid, count);
        return fs;
    }
}

