/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class UtilSound {
    public static void playSound(World world, BlockPos pos, SoundEvent soundIn) {
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundIn, SoundCategory.BLOCKS, 0.5f, 0.5f, false);
    }

    public static void playSound(World world, BlockPos pos, SoundEvent soundIn, float volume) {
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundIn, SoundCategory.BLOCKS, volume, 0.5f, false);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn) {
        UtilSound.playSound(entityIn, soundIn, 1.0f, 1.0f);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn, float volume) {
        UtilSound.playSound(entityIn, soundIn, volume, 1.0f);
    }

    public static void playSound(Entity entityIn, SoundEvent soundIn, float volume, float pitch) {
        if (entityIn != null && entityIn.field_70170_p.field_72995_K) {
            entityIn.func_184185_a(soundIn, volume, pitch);
        }
    }

    public static void playSoundFromServer(ServerPlayerEntity entityIn, BlockPos pos, SoundEvent soundIn) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(soundIn, SoundCategory.BLOCKS, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, 1.0f));
    }

    public static void playSoundFromServer(ServerPlayerEntity entityIn, SoundEvent soundIn) {
        if (soundIn == null || entityIn == null) {
            return;
        }
        entityIn.field_71135_a.func_147359_a((IPacket)new SPlaySoundEffectPacket(soundIn, SoundCategory.BLOCKS, entityIn.field_70142_S, entityIn.field_70137_T, entityIn.field_70136_U, 1.0f, 1.0f));
    }

    public static void playSoundFromServer(ServerWorld world, BlockPos pos, SoundEvent soundIn) {
        for (ServerPlayerEntity sp : world.func_217369_A()) {
            UtilSound.playSoundFromServer(sp, pos, soundIn);
        }
    }

    public static void playSoundFromServerById(ServerWorld world, BlockPos pos, String sid) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(sid));
        if (sound != null) {
            for (ServerPlayerEntity sp : world.func_217369_A()) {
                UtilSound.playSoundFromServer(sp, pos, sound);
            }
        }
    }

    public static void playSoundById(PlayerEntity player, String sid) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(sid));
        if (sound != null && player.field_70170_p.field_72995_K) {
            UtilSound.playSound((Entity)player, sound);
        }
    }
}

