/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.attrib;

import com.jozufozu.flywheel.backend.gl.GlNumericType;
import com.jozufozu.flywheel.backend.gl.attrib.IAttribSpec;
import org.lwjgl.opengl.GL20;

public enum MatrixAttributes implements IAttribSpec
{
    MAT3(3, 3),
    MAT4(4, 4);

    private final int rows;
    private final int cols;

    private MatrixAttributes(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public void vertexAttribPointer(int stride, int index, int pointer) {
        for (int i = 0; i < this.rows; ++i) {
            long attribPointer = (long)pointer + (long)i * (long)this.cols * (long)GlNumericType.FLOAT.getByteWidth();
            GL20.glVertexAttribPointer((int)(index + i), (int)this.cols, (int)GlNumericType.FLOAT.getGlEnum(), (boolean)false, (int)stride, (long)attribPointer);
        }
    }

    @Override
    public int getSize() {
        return GlNumericType.FLOAT.getByteWidth() * this.rows * this.cols;
    }

    @Override
    public int getAttributeCount() {
        return this.rows;
    }
}

