/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferUsage;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBufferRange;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBufferUsage;
import com.jozufozu.flywheel.backend.gl.buffer.MappedFullBuffer;
import com.jozufozu.flywheel.backend.gl.versioned.MapBufferRange;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class GlBuffer
extends GlObject {
    protected final GlBufferType type;
    protected final GlBufferUsage usage;

    public GlBuffer(GlBufferType type) {
        this(type, GlBufferUsage.STATIC_DRAW);
    }

    public GlBuffer(GlBufferType type, GlBufferUsage usage) {
        this.setHandle(GL20.glGenBuffers());
        this.type = type;
        this.usage = usage;
    }

    public GlBufferType getBufferTarget() {
        return this.type;
    }

    public void bind() {
        this.bind(this.type);
    }

    public void bind(GlBufferType type) {
        GL20.glBindBuffer((int)type.glEnum, (int)this.handle());
    }

    public void unbind() {
        this.unbind(this.type);
    }

    public void unbind(GlBufferType bufferType) {
        GL20.glBindBuffer((int)bufferType.glEnum, (int)0);
    }

    public void alloc(int size) {
        GL15.glBufferData((int)this.type.glEnum, (long)size, (int)this.usage.glEnum);
    }

    public void upload(ByteBuffer directBuffer) {
        GL15.glBufferData((int)this.type.glEnum, (ByteBuffer)directBuffer, (int)this.usage.glEnum);
    }

    public MappedBuffer getBuffer(int offset, int length) {
        if (Backend.getInstance().compat.mapBufferRange != MapBufferRange.UNSUPPORTED) {
            return new MappedBufferRange(this, offset, length, 2);
        }
        MappedFullBuffer fullBuffer = new MappedFullBuffer(this, MappedBufferUsage.WRITE_ONLY);
        fullBuffer.position(offset);
        return fullBuffer;
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteBuffers((int)handle);
    }
}

