/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.versioned.instancing;

import com.jozufozu.flywheel.backend.gl.versioned.GlVersioned;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;

public enum VertexArrayObject implements GlVersioned
{
    GL30_VAO{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.OpenGL30;
        }

        @Override
        public int genVertexArrays() {
            return GL30.glGenVertexArrays();
        }

        @Override
        public void bindVertexArray(int array) {
            GL30.glBindVertexArray((int)array);
        }

        @Override
        public void deleteVertexArrays(int array) {
            GL30.glDeleteVertexArrays((int)array);
        }
    }
    ,
    ARB_VAO{

        @Override
        public boolean supported(GLCapabilities caps) {
            return caps.GL_ARB_vertex_array_object;
        }

        @Override
        public int genVertexArrays() {
            return ARBVertexArrayObject.glGenVertexArrays();
        }

        @Override
        public void bindVertexArray(int array) {
            ARBVertexArrayObject.glBindVertexArray((int)array);
        }

        @Override
        public void deleteVertexArrays(int array) {
            ARBVertexArrayObject.glDeleteVertexArrays((int)array);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public boolean supported(GLCapabilities caps) {
            return true;
        }

        @Override
        public int genVertexArrays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindVertexArray(int array) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteVertexArrays(int array) {
            throw new UnsupportedOperationException();
        }
    };


    public abstract int genVertexArrays();

    public abstract void bindVertexArray(int var1);

    public abstract void deleteVertexArrays(int var1);
}

