/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.google.common.collect.Maps;
import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.backend.instancing.entity.IEntityInstanceFactory;
import com.jozufozu.flywheel.backend.instancing.tile.ITileInstanceFactory;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class InstancedRenderRegistry {
    private static final InstancedRenderRegistry INSTANCE = new InstancedRenderRegistry();
    private final Object2BooleanMap<Object> skipRender = new Object2BooleanLinkedOpenHashMap();
    private final Map<TileEntityType<?>, ITileInstanceFactory<?>> tiles = Maps.newHashMap();
    private final Map<EntityType<?>, IEntityInstanceFactory<?>> entities = Maps.newHashMap();

    public static InstancedRenderRegistry getInstance() {
        return INSTANCE;
    }

    protected InstancedRenderRegistry() {
        this.skipRender.defaultReturnValue(false);
    }

    public <T extends TileEntity> boolean shouldSkipRender(T type) {
        return this._skipRender(type.func_200662_C()) || type instanceof IInstanceRendered && !((IInstanceRendered)type).shouldRenderNormally();
    }

    public <T extends Entity> boolean shouldSkipRender(T type) {
        return this._skipRender(type.func_200600_R()) || type instanceof IInstanceRendered && !((IInstanceRendered)type).shouldRenderNormally();
    }

    public <T extends TileEntity> boolean canInstance(TileEntityType<? extends T> type) {
        return this.tiles.containsKey(type);
    }

    public <T extends Entity> boolean canInstance(EntityType<? extends T> type) {
        return this.entities.containsKey(type);
    }

    public <T extends TileEntity> TileConfig<? extends T> tile(TileEntityType<? extends T> type) {
        return new TileConfig<T>(type);
    }

    public <T extends Entity> EntityConfig<? extends T> entity(EntityType<? extends T> type) {
        return new EntityConfig<T>(type);
    }

    @Deprecated
    public <T extends TileEntity> void register(TileEntityType<? extends T> type, ITileInstanceFactory<? super T> rendererFactory) {
        this.tile(type).factory(rendererFactory);
    }

    @Deprecated
    public <T extends Entity> void register(EntityType<? extends T> type, IEntityInstanceFactory<? super T> rendererFactory) {
        this.entity(type).factory(rendererFactory);
    }

    @Nullable
    public <T extends TileEntity> TileEntityInstance<? super T> create(MaterialManager<?> manager, T tile) {
        TileEntityType type = tile.func_200662_C();
        ITileInstanceFactory<?> factory = this.tiles.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(manager, tile);
    }

    @Nullable
    public <T extends Entity> EntityInstance<? super T> create(MaterialManager<?> manager, T tile) {
        EntityType type = tile.func_200600_R();
        IEntityInstanceFactory<?> factory = this.entities.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(manager, tile);
    }

    private boolean _skipRender(Object o) {
        return this.skipRender.getBoolean(o);
    }

    public class EntityConfig<T extends Entity> {
        private final EntityType<T> type;

        public EntityConfig(EntityType<T> type) {
            this.type = type;
        }

        public EntityConfig<T> factory(IEntityInstanceFactory<? super T> rendererFactory) {
            InstancedRenderRegistry.this.entities.put(this.type, rendererFactory);
            return this;
        }

        public EntityConfig<T> setSkipRender(boolean skipRender) {
            InstancedRenderRegistry.this.skipRender.put(this.type, skipRender);
            return this;
        }
    }

    public class TileConfig<T extends TileEntity> {
        private final TileEntityType<T> type;

        public TileConfig(TileEntityType<T> type) {
            this.type = type;
        }

        public TileConfig<T> factory(ITileInstanceFactory<? super T> rendererFactory) {
            InstancedRenderRegistry.this.tiles.put(this.type, rendererFactory);
            return this;
        }

        public TileConfig<T> setSkipRender(boolean skipRender) {
            InstancedRenderRegistry.this.skipRender.put(this.type, skipRender);
            return this;
        }
    }
}

