/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;

public class PartialModel {
    private static boolean tooLate = false;
    private static final List<PartialModel> all = new ArrayList<PartialModel>();
    protected final ResourceLocation modelLocation;
    protected IBakedModel bakedModel;

    public PartialModel(ResourceLocation modelLocation) {
        if (tooLate) {
            throw new RuntimeException("PartialModel '" + modelLocation + "' loaded after ModelRegistryEvent");
        }
        this.modelLocation = modelLocation;
        all.add(this);
    }

    public static void onModelRegistry(ModelRegistryEvent event) {
        for (PartialModel partial : all) {
            ModelLoader.addSpecialModel((ResourceLocation)partial.modelLocation);
        }
        tooLate = true;
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        for (PartialModel partial : all) {
            partial.bakedModel = (IBakedModel)modelRegistry.get(partial.modelLocation);
        }
    }

    public IBakedModel get() {
        return this.bakedModel;
    }
}

