/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class ModelUtil {
    private static final Lazy<BlockModelRenderer> MODEL_RENDERER = Lazy.of(() -> new BlockModelRenderer(Minecraft.func_71410_x().func_184125_al()));
    private static final Lazy<BlockModelShapes> BLOCK_MODELS = Lazy.of(() -> Minecraft.func_71410_x().func_209506_al().func_174954_c());

    public static BufferBuilder getBufferBuilderFromTemplate(IBlockDisplayReader renderWorld, RenderType layer, Collection<Template.BlockInfo> blocks) {
        MatrixStack ms = new MatrixStack();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        BlockModelRenderer.func_211847_a();
        for (Template.BlockInfo info : blocks) {
            BlockState state = info.field_186243_b;
            if (state.func_185901_i() != BlockRenderType.MODEL || !RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            BlockPos pos = info.field_186242_a;
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            ((BlockModelRenderer)MODEL_RENDERER.get()).renderModel(renderWorld, ((BlockModelShapes)BLOCK_MODELS.get()).func_178125_b(state), state, pos, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
        BlockModelRenderer.func_210266_a();
        ForgeHooksClient.setRenderLayer(null);
        builder.func_178977_d();
        return builder;
    }
}

