/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.core.shader.ExtensibleGlProgram;
import com.jozufozu.flywheel.core.shader.extension.IProgramExtension;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import java.util.List;
import net.minecraft.util.math.vector.Matrix4f;
import org.lwjgl.opengl.GL20;

public class WorldProgram
extends ExtensibleGlProgram {
    protected final int uTime = this.getUniformLocation("uTime");
    protected final int uViewProjection = this.getUniformLocation("uViewProjection");
    protected final int uCameraPos = this.getUniformLocation("uCameraPos");
    protected int uBlockAtlas;
    protected int uLightMap;

    public WorldProgram(Program program, List<IProgramExtension> extensions) {
        super(program, extensions);
        super.bind();
        this.registerSamplers();
        super.unbind();
    }

    protected void registerSamplers() {
        this.uBlockAtlas = this.setSamplerBinding("uBlockAtlas", 0);
        this.uLightMap = this.setSamplerBinding("uLightMap", 2);
    }

    public void uploadViewProjection(Matrix4f viewProjection) {
        WorldProgram.uploadMatrixUniform(this.uViewProjection, viewProjection);
    }

    public void uploadCameraPos(double camX, double camY, double camZ) {
        GL20.glUniform3f((int)this.uCameraPos, (float)((float)camX), (float)((float)camY), (float)((float)camZ));
    }

    public void uploadTime(float renderTime) {
        GL20.glUniform1f((int)this.uTime, (float)renderTime);
    }

    @Override
    public void bind() {
        super.bind();
        this.uploadTime(AnimationTickHolder.getRenderTime());
    }
}

