/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SpaceChamberControllerTileEntity
extends GenericTileEntity {
    private BlockPos minCorner;
    private BlockPos maxCorner;
    private int channel = -1;

    public SpaceChamberControllerTileEntity() {
        super((TileEntityType)BuilderModule.TYPE_SPACE_CHAMBER_CONTROLLER.get());
    }

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(PlayerEntity player) {
        int i;
        BlockPos pos = this.func_174877_v();
        int x1 = pos.func_177958_n();
        int y1 = pos.func_177956_o();
        int z1 = pos.func_177952_p();
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (x2 == x1) {
                if (this.func_145831_w().func_180495_p(new BlockPos(x1 - i, y1, z1)).func_177230_c() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 - i;
                } else if (this.field_145850_b.func_180495_p(new BlockPos(x1 + i, y1, z1)).func_177230_c() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.field_145850_b.func_180495_p(new BlockPos(x1, y1, z1 - i)).func_177230_c() == BuilderModule.SPACE_CHAMBER.get()) {
                z2 = z1 - i;
                continue;
            }
            if (this.field_145850_b.func_180495_p(new BlockPos(x1, y1, z1 + i)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(x2, y1, z2)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (this.field_145850_b.func_180495_p(new BlockPos(x1, y1 - i, z1)).func_177230_c() == BuilderModule.SPACE_CHAMBER.get()) {
                y2 = y1 - i;
                break;
            }
            if (this.field_145850_b.func_180495_p(new BlockPos(x1, y1 + i, z1)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(x2, y2, z2)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(x1, y2, z2)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(x2, y2, z1)).func_177230_c() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        this.minCorner = new BlockPos(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new BlockPos(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.func_177958_n() > this.maxCorner.func_177958_n() || this.minCorner.func_177956_o() > this.maxCorner.func_177956_o() || this.minCorner.func_177952_p() > this.maxCorner.func_177952_p()) {
            Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "Chamber is too small!"));
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        Logging.message((PlayerEntity)player, (String)(TextFormatting.WHITE + "Chamber succesfully created!"));
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.get(this.field_145850_b);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.channel);
        chamberChannel.setDimension(DimensionId.fromWorld((World)this.field_145850_b));
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save();
        this.markDirtyClient();
    }

    public int getChannel() {
        return this.channel;
    }

    public int getChamberSize() {
        if (this.channel == -1) {
            return -1;
        }
        if (this.minCorner == null) {
            return -1;
        }
        return (this.maxCorner.func_177958_n() - this.minCorner.func_177958_n()) * (this.maxCorner.func_177956_o() - this.minCorner.func_177956_o()) * (this.maxCorner.func_177952_p() - this.minCorner.func_177952_p());
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.markDirtyClient();
    }

    public void read(CompoundNBT tagCompound) {
        super.read(tagCompound);
        this.minCorner = BlockPosTools.read((CompoundNBT)tagCompound, (String)"minCorner");
        this.maxCorner = BlockPosTools.read((CompoundNBT)tagCompound, (String)"maxCorner");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"minCorner", (BlockPos)this.minCorner);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"maxCorner", (BlockPos)this.maxCorner);
        return tagCompound;
    }
}

