/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GuiChamberDetails
extends GuiItemScreen {
    private static final int CHAMBER_XSIZE = 390;
    private static final int CHAMBER_YSIZE = 210;
    private static Map<BlockState, Integer> items = null;
    private static Map<BlockState, Integer> costs = null;
    private static Map<BlockState, ItemStack> stacks = null;
    private static Map<String, Integer> entities = null;
    private static Map<String, Integer> entityCosts = null;
    private static Map<String, Entity> realEntities = null;
    private static Map<String, String> playerNames = null;
    private WidgetList blockList;
    private Label infoLabel;
    private Label info2Label;

    public GuiChamberDetails() {
        super(RFToolsBuilderMessages.INSTANCE, 390, 210, ManualEntry.EMPTY);
        this.requestChamberInfoFromServer();
    }

    public static void setItemsWithCount(Map<BlockState, Integer> items, Map<BlockState, Integer> costs, Map<BlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities, Map<String, String> playerNames) {
        GuiChamberDetails.items = new HashMap<BlockState, Integer>(items);
        GuiChamberDetails.costs = new HashMap<BlockState, Integer>(costs);
        GuiChamberDetails.stacks = new HashMap<BlockState, ItemStack>(stacks);
        GuiChamberDetails.entities = new HashMap<String, Integer>(entities);
        GuiChamberDetails.entityCosts = new HashMap<String, Integer>(entityCosts);
        GuiChamberDetails.realEntities = new HashMap<String, Entity>(realEntities);
        GuiChamberDetails.playerNames = new HashMap<String, String>(playerNames);
    }

    private void requestChamberInfoFromServer() {
        RFToolsBuilderMessages.sendToServer("getChamberInfo");
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.blockList = (WidgetList)new WidgetList().name("blocks");
        Slider listSlider = ((Slider)new Slider().desiredWidth(10)).vertical().scrollableName("blocks");
        Panel listPanel = (Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.blockList, listSlider});
        this.infoLabel = (Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.infoLabel.desiredWidth(380)).desiredHeight(14);
        this.info2Label = (Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        ((Label)this.info2Label.desiredWidth(380)).desiredHeight(14);
        Panel toplevel = (Panel)((Panel)Widgets.vertical((int)3, (int)1).filledRectThickness(2)).children(new Widget[]{listPanel, this.infoLabel, this.info2Label});
        toplevel.bounds(this.guiLeft, this.guiTop, this.xSize, this.ySize);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
    }

    private void populateLists() {
        this.blockList.removeChildren();
        if (items == null) {
            return;
        }
        int totalCost = 0;
        for (Map.Entry<BlockState, Integer> entry : items.entrySet()) {
            ItemStack stack;
            BlockState bm = entry.getKey();
            int count = entry.getValue();
            int cost = costs.get(bm);
            Panel panel = (Panel)Widgets.horizontal().desiredHeight(16);
            if (stacks.containsKey(bm)) {
                stack = stacks.get(bm);
            } else {
                stack = bm.func_177230_c().func_185473_a((IBlockReader)Minecraft.func_71410_x().field_71441_e, BlockPos.field_177992_a, bm);
                if (stack.func_190926_b()) {
                    stack = new ItemStack((IItemProvider)bm.func_177230_c(), 0);
                }
            }
            BlockRender blockRender = new BlockRender().renderItem((Object)stack).offsetX(-1).offsetY(-1);
            Label nameLabel = (Label)((Label)new Label().horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).color(StyleConfig.colorTextInListNormal);
            if (stack.func_77973_b() == null) {
                ((Label)nameLabel.text("?")).desiredWidth(160);
            } else {
                ((Label)nameLabel.text(stack.func_200301_q().getString())).desiredWidth(160);
            }
            Label countLabel = (Label)Widgets.label((String)String.valueOf(count)).color(StyleConfig.colorTextInListNormal);
            ((Label)countLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(50);
            Label costLabel = (Label)new Label().color(StyleConfig.colorTextInListNormal);
            costLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.text("NOT MOVABLE!");
            } else {
                costLabel.text("Move Cost " + cost + " RF");
                totalCost += cost;
            }
            panel.children(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.children(new Widget[]{panel});
        }
        int totalCostEntities = 0;
        RenderHelper.rot += 0.5f;
        for (Map.Entry<String, Integer> entry : entities.entrySet()) {
            String className = entry.getKey();
            int count = entry.getValue();
            int cost = entityCosts.get(className);
            Panel panel = (Panel)Widgets.horizontal().desiredHeight(16);
            String entityName = "<?>";
            Entity entity = null;
            if (realEntities.containsKey(className)) {
                ItemEntity entityItem;
                entity = realEntities.get(className);
                entityName = entity.func_145748_c_().getString();
                if (entity instanceof ItemEntity && !(entityItem = (ItemEntity)entity).func_92059_d().func_190926_b()) {
                    String displayName = entityItem.func_92059_d().func_151000_E().getString();
                    entityName = entityName + " (" + displayName + ")";
                }
            } else {
                try {
                    Class<?> aClass = Class.forName(className);
                    entity = (Entity)aClass.getConstructor(World.class).newInstance(this.field_230706_i_.field_71441_e);
                    entityName = aClass.getSimpleName();
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (InstantiationException aClass) {
                }
                catch (IllegalAccessException aClass) {
                }
                catch (InvocationTargetException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            if (playerNames.containsKey(className)) {
                entityName = playerNames.get(className);
            }
            BlockRender blockRender = new BlockRender().renderItem((Object)entity).offsetX(-1).offsetY(-1);
            Label nameLabel = (Label)((Label)Widgets.label((String)entityName).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(160);
            Label countLabel = Widgets.label((String)String.valueOf(count));
            ((Label)countLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(50);
            Label costLabel = new Label();
            costLabel.horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
            if (cost == -1) {
                costLabel.text("NOT MOVABLE!");
            } else {
                costLabel.text("Move Cost " + cost + " RF");
                totalCostEntities += cost;
            }
            panel.children(new Widget[]{blockRender, nameLabel, countLabel, costLabel});
            this.blockList.children(new Widget[]{panel});
        }
        this.infoLabel.text("Total cost blocks: " + totalCost + " RF");
        this.info2Label.text("Total cost entities: " + totalCostEntities + " RF");
    }

    public void func_230430_a_(MatrixStack matrixStack, int xSize_lo, int ySize_lo, float par3) {
        super.func_230430_a_(matrixStack, xSize_lo, ySize_lo, par3);
        this.populateLists();
        this.drawWindow(matrixStack);
    }

    public static void open() {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiChamberDetails());
    }
}

