/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateNBTShapeCard {
    private TypedMap args;

    public void toBytes(PacketBuffer buf) {
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.args);
    }

    public PacketUpdateNBTShapeCard() {
    }

    public PacketUpdateNBTShapeCard(PacketBuffer buf) {
        this.args = TypedMapTools.readArguments((PacketBuffer)buf);
    }

    public PacketUpdateNBTShapeCard(TypedMap arguments) {
        this.args = arguments;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            CompoundNBT tagCompound = heldItem.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new CompoundNBT();
                heldItem.func_77982_d(tagCompound);
            }
            for (Key akey : this.args.getKeys()) {
                String key = akey.getName();
                if (Type.STRING.equals(akey.getType())) {
                    tagCompound.func_74778_a(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.getType())) {
                    tagCompound.func_74768_a(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.getType())) {
                    tagCompound.func_74780_a(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.getType())) {
                    tagCompound.func_74757_a(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.getType())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (!Type.ITEMSTACK.equals(akey.getType())) continue;
                throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

