/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ShieldingBlock
extends Block {
    public static final BooleanProperty BLOCKED_ITEMS = BooleanProperty.func_177716_a((String)"bi");
    public static final BooleanProperty BLOCKED_PASSIVE = BooleanProperty.func_177716_a((String)"bp");
    public static final BooleanProperty BLOCKED_HOSTILE = BooleanProperty.func_177716_a((String)"bh");
    public static final BooleanProperty BLOCKED_PLAYERS = BooleanProperty.func_177716_a((String)"bplay");
    public static final BooleanProperty DAMAGE_ITEMS = BooleanProperty.func_177716_a((String)"di");
    public static final BooleanProperty DAMAGE_PASSIVE = BooleanProperty.func_177716_a((String)"dp");
    public static final BooleanProperty DAMAGE_HOSTILE = BooleanProperty.func_177716_a((String)"dh");
    public static final BooleanProperty DAMAGE_PLAYERS = BooleanProperty.func_177716_a((String)"dplay");
    public static final BooleanProperty FLAG_OPAQUE = BooleanProperty.func_177716_a((String)"opaque");
    public static final EnumProperty<ShieldRenderingMode> RENDER_MODE = EnumProperty.func_177709_a((String)"render", ShieldRenderingMode.class);
    public static final VoxelShape COLLISION_SHAPE = VoxelShapes.func_197873_a((double)0.002, (double)0.002, (double)0.002, (double)0.998, (double)0.998, (double)0.998);

    public ShieldingBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_235828_a_((state, world, pos) -> false).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BLOCKED_ITEMS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DAMAGE_ITEMS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FLAG_OPAQUE, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ShieldingTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BLOCKED_ITEMS, BLOCKED_HOSTILE, BLOCKED_PASSIVE, BLOCKED_PLAYERS, DAMAGE_ITEMS, DAMAGE_HOSTILE, DAMAGE_PASSIVE, DAMAGE_PLAYERS, FLAG_OPAQUE, RENDER_MODE});
    }

    public int func_200011_d(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)FLAG_OPAQUE) != false ? 0 : 255;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return state.func_177229_b(RENDER_MODE) == ShieldRenderingMode.INVISIBLE ? BlockRenderType.INVISIBLE : BlockRenderType.MODEL;
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_220080_a(state, worldIn, pos);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        BlockState mimic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.func_215700_a(world, pos, context);
        }
        if (state.func_177229_b(RENDER_MODE) == ShieldRenderingMode.INVISIBLE) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_220053_a(state, world, pos, context);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState mimic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.func_199611_f(world, pos, ISelectionContext.func_216377_a());
        }
        if (state.func_177229_b(RENDER_MODE) == ShieldRenderingMode.INVISIBLE) {
            return VoxelShapes.func_197880_a();
        }
        return super.func_199600_g(state, world, pos);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState mimic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.func_235754_c_(world, pos);
        }
        return super.func_196247_c(state, world, pos);
    }

    public static boolean isHostile(Entity entity) {
        return entity instanceof IMob;
    }

    public static boolean isPassive(Entity entity) {
        if (entity instanceof IMob) {
            return false;
        }
        if (entity instanceof PlayerEntity) {
            return false;
        }
        return entity instanceof MobEntity;
    }

    public static boolean isItem(Entity entity) {
        return !(entity instanceof LivingEntity);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Entity entity = context.getEntity();
        if (((Boolean)state.func_177229_b((Property)BLOCKED_HOSTILE)).booleanValue() && ShieldingBlock.isHostile(entity)) {
            if (this.checkEntityCD(world, pos, "hostile")) {
                return COLLISION_SHAPE;
            }
            return VoxelShapes.func_197880_a();
        }
        if (((Boolean)state.func_177229_b((Property)BLOCKED_PASSIVE)).booleanValue() && ShieldingBlock.isPassive(entity)) {
            if (this.checkEntityCD(world, pos, "animal")) {
                return COLLISION_SHAPE;
            }
            return VoxelShapes.func_197880_a();
        }
        if (((Boolean)state.func_177229_b((Property)BLOCKED_PLAYERS)).booleanValue() && entity instanceof PlayerEntity) {
            if (this.checkPlayerCD(world, pos, (PlayerEntity)entity)) {
                return COLLISION_SHAPE;
            }
            return VoxelShapes.func_197880_a();
        }
        if (((Boolean)state.func_177229_b((Property)BLOCKED_ITEMS)).booleanValue() && ShieldingBlock.isItem(entity)) {
            if (this.checkEntityCD(world, pos, "item")) {
                return COLLISION_SHAPE;
            }
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197880_a();
    }

    private boolean checkEntityCD(IBlockReader world, BlockPos pos, String filterName) {
        ShieldProjectorTileEntity projector = this.getShieldProjector(world, pos);
        if (projector != null) {
            List<ShieldFilter> filters = projector.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!filterName.equals(filter.getFilterName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    private boolean checkPlayerCD(IBlockReader world, BlockPos pos, PlayerEntity entity) {
        ShieldProjectorTileEntity projector = this.getShieldProjector(world, pos);
        if (projector != null) {
            List<ShieldFilter> filters = projector.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!"player".equals(filter.getFilterName())) continue;
                PlayerFilter playerFilter = (PlayerFilter)filter;
                String name = playerFilter.getName();
                if (name == null || name.isEmpty()) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!name.equals(entity.func_200200_C_().getString())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() == this ? true : super.func_200122_a(state, adjacentBlockState, side);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) && !((Boolean)state.func_177229_b((Property)BLOCKED_ITEMS)).booleanValue()) {
            entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
        }
        this.handleDamage(state, world, pos, entity);
    }

    @Nullable
    private ShieldProjectorTileEntity getShieldProjector(IBlockReader world, BlockPos shieldingPos) {
        TileEntity tileEntity;
        BlockPos projectorPos;
        TileEntity te = world.func_175625_s(shieldingPos);
        if (te instanceof ShieldingTileEntity && (projectorPos = ((ShieldingTileEntity)te).getShieldProjector()) != null && (tileEntity = world.func_175625_s(projectorPos)) instanceof ShieldProjectorTileEntity) {
            return (ShieldProjectorTileEntity)tileEntity;
        }
        return null;
    }

    public void handleDamage(BlockState state, World world, BlockPos pos, Entity entity) {
        ShieldProjectorTileEntity projector;
        Boolean dmgHostile = (Boolean)state.func_177229_b((Property)DAMAGE_HOSTILE);
        Boolean dmgPassive = (Boolean)state.func_177229_b((Property)DAMAGE_PASSIVE);
        Boolean dmgPlayer = (Boolean)state.func_177229_b((Property)DAMAGE_PLAYERS);
        Boolean dmgItems = (Boolean)state.func_177229_b((Property)DAMAGE_ITEMS);
        if (!dmgHostile.booleanValue() && !dmgPassive.booleanValue() && !dmgPlayer.booleanValue() && !dmgItems.booleanValue() || world.field_72995_K || world.func_82737_E() % 10L != 0L) {
            return;
        }
        int xCoord = pos.func_177958_n();
        int yCoord = pos.func_177956_o();
        int zCoord = pos.func_177952_p();
        AxisAlignedBB beamBox = new AxisAlignedBB((double)xCoord - 0.4, (double)yCoord - 0.4, (double)zCoord - 0.4, (double)xCoord + 1.4, (double)yCoord + 2.0, (double)zCoord + 1.4);
        if (entity.func_174813_aQ().func_72326_a(beamBox) && (projector = this.getShieldProjector((IBlockReader)world, pos)) != null) {
            if (dmgItems.booleanValue() && entity instanceof ItemEntity) {
                if (this.checkEntityDamage(projector, "item")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgHostile.booleanValue() && ShieldingBlock.isHostile(entity)) {
                if (this.checkEntityDamage(projector, "hostile")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgPassive.booleanValue() && ShieldingBlock.isPassive(entity)) {
                if (this.checkEntityDamage(projector, "animal")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgPlayer.booleanValue() && entity instanceof PlayerEntity && this.checkPlayerDamage(projector, (PlayerEntity)entity)) {
                projector.applyDamageToEntity(entity);
            }
        }
    }

    private boolean checkEntityDamage(@Nonnull ShieldProjectorTileEntity shieldTileEntity, String filterName) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!filterName.equals(filter.getFilterName())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }

    private boolean checkPlayerDamage(@Nonnull ShieldProjectorTileEntity shieldTileEntity, PlayerEntity entity) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!"player".equals(filter.getFilterName())) continue;
            PlayerFilter playerFilter = (PlayerFilter)filter;
            String name = playerFilter.getName();
            if (name == null || name.isEmpty()) {
                return (filter.getAction() & 2) != 0;
            }
            if (!name.equals(entity.func_200200_C_().getString())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }
}

