/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class Scan {
    private byte[] rledata;
    private List<BlockState> materialPalette = new ArrayList<BlockState>();
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private int dirtyCounter = 0;
    public int dirtyRequestTimeout = 0;
    public static final byte[] EMPTY = new byte[0];

    public byte[] getRledata() {
        if (this.rledata == null) {
            return EMPTY;
        }
        return this.rledata;
    }

    public byte[] getDataInt() {
        return this.rledata;
    }

    public void setData(byte[] data, List<BlockState> materialPalette, BlockPos dim, BlockPos offset) {
        this.rledata = data;
        this.materialPalette = materialPalette;
        this.dataDim = dim;
        this.dataOffset = offset;
        ++this.dirtyCounter;
    }

    public void setDirtyCounter(int dirtyCounter) {
        this.dirtyCounter = dirtyCounter;
    }

    public int getDirtyCounter() {
        return this.dirtyCounter;
    }

    public List<BlockState> getMaterialPalette() {
        return this.materialPalette;
    }

    public BlockPos getDataDim() {
        return this.dataDim;
    }

    public BlockPos getDataOffset() {
        return this.dataOffset;
    }

    public void writeToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74768_a("dirty", this.dirtyCounter);
    }

    public void writeToNBTExternal(CompoundNBT tagCompound) {
        tagCompound.func_74773_a("data", this.rledata == null ? new byte[]{} : this.rledata);
        ListNBT pal = new ListNBT();
        for (BlockState state : this.materialPalette) {
            CompoundNBT tc = NBTUtil.func_190009_a((BlockState)state);
            pal.add((Object)tc);
        }
        tagCompound.func_218657_a("scanpal", (INBT)pal);
        if (this.dataDim != null) {
            tagCompound.func_74768_a("scandimx", this.dataDim.func_177958_n());
            tagCompound.func_74768_a("scandimy", this.dataDim.func_177956_o());
            tagCompound.func_74768_a("scandimz", this.dataDim.func_177952_p());
        }
        if (this.dataOffset != null) {
            tagCompound.func_74768_a("scanoffx", this.dataOffset.func_177958_n());
            tagCompound.func_74768_a("scanoffy", this.dataOffset.func_177956_o());
            tagCompound.func_74768_a("scanoffz", this.dataOffset.func_177952_p());
        }
    }

    public void readFromNBT(CompoundNBT tagCompound) {
        this.dirtyCounter = tagCompound.func_74762_e("dirty");
    }

    public void readFromNBTExternal(CompoundNBT tagCompound) {
        ListNBT list = tagCompound.func_150295_c("scanpal", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tc = list.func_150305_b(i);
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)tc);
            this.materialPalette.add(state);
        }
        this.rledata = tagCompound.func_74770_j("data");
        this.dataDim = new BlockPos(tagCompound.func_74762_e("scandimx"), tagCompound.func_74762_e("scandimy"), tagCompound.func_74762_e("scandimz"));
        this.dataOffset = new BlockPos(tagCompound.func_74762_e("scanoffx"), tagCompound.func_74762_e("scanoffy"), tagCompound.func_74762_e("scanoffz"));
    }
}

