/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.gui.window.WindowSetAccessory;
import me.ichun.mods.hats.client.gui.window.WindowSetColouriser;
import me.ichun.mods.hats.client.gui.window.element.ElementHatRender;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButtonTextured;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextured;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class WindowHatOptions
extends Window<WorkspaceHats> {
    @Nonnull
    private final ElementHatRender<?> parentElement;
    private final int parentLeft;
    private final int parentTop;
    private boolean killed;

    public WindowHatOptions(WorkspaceHats parent, @Nonnull ElementHatRender<?> parentElement) {
        super((IWindows)parent);
        this.setBorderSize(() -> 0);
        this.disableBringToFront();
        this.disableDocking();
        this.disableDockStacking();
        this.disableUndocking();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
        this.parentElement = parentElement;
        this.parentLeft = parentElement.getLeft();
        this.parentTop = parentElement.getTop();
        this.setView(new ViewHatOptions(this));
    }

    public void renderBackground(MatrixStack stack) {
    }

    public int getMinWidth() {
        return 21;
    }

    public void unfocus(@Nullable IGuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        if (!this.killed) {
            this.killed = true;
            ((WorkspaceHats)this.parent).removeWindow(this);
        }
    }

    public void setScissor() {
        this.currentView.setScissor();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.parentLeft != this.parentElement.getLeft() || this.parentTop != this.parentElement.getTop()) {
            this.killed = true;
            ((WorkspaceHats)this.parent).removeWindow(this);
            return;
        }
        if (!this.killed) {
            super.func_230430_a_(stack, mouseX, mouseY, partialTick);
        }
    }

    public static class ViewHatOptions
    extends View<WindowHatOptions> {
        public static ResourceLocation TEX_COLOURISE = new ResourceLocation("hats", "textures/icon/colourise.png");
        public static ResourceLocation TEX_PERSONALISE = new ResourceLocation("hats", "textures/icon/personalise.png");
        public static ResourceLocation TEX_FAVOURITE = new ResourceLocation("hats", "textures/icon/favourite.png");
        public ArrayList<Element<?>> buttons = new ArrayList();
        public int age;

        public ViewHatOptions(@Nonnull WindowHatOptions parent) {
            super((Window)parent, "hats.gui.window.hat.sidebar");
            int padding = (parent.parentElement.getHeight() - 60) / 2;
            ElementButtonTextured btnStack = new ElementButtonTextured((Fragment)this, TEX_COLOURISE, btn -> {
                ViewHatOptions.openColouriser((WorkspaceHats)parent.parent, parent.parentElement);
                ((WorkspaceHats)parent.parent).removeWindow(parent);
            });
            btnStack.setTooltip(I18n.func_135052_a((String)"hats.gui.button.colourise", (Object[])new Object[0]));
            btnStack.setSize(20, 20);
            btnStack.constraints().right((IConstrainable)this, Constraint.Property.Type.LEFT, 1).top((IConstrainable)this, Constraint.Property.Type.TOP, 0);
            this.elements.add(btnStack);
            this.buttons.add((Element<?>)btnStack);
            ElementButtonTextured btnStackLast = btnStack;
            if (((WindowHatOptions)parent).parentElement.hatLevel.hasUnlockedAccessory()) {
                btnStack = new ElementButtonTextured((Fragment)this, TEX_PERSONALISE, btn -> {
                    ViewHatOptions.openPersonalizer((WorkspaceHats)parent.parent, parent.parentElement);
                    ((WorkspaceHats)parent.parent).removeWindow(parent);
                });
                btnStack.setTooltip(I18n.func_135052_a((String)"hats.gui.button.personalise", (Object[])new Object[0]));
                btnStack.setSize(20, 20);
                btnStack.constraints().right((IConstrainable)this, Constraint.Property.Type.LEFT, 1).top((IConstrainable)btnStackLast, Constraint.Property.Type.BOTTOM, padding);
                this.elements.add(btnStack);
                this.buttons.add((Element<?>)btnStack);
                btnStackLast = btnStack;
            }
            ElementToggleTextured btnToggle = new ElementToggleTextured((Fragment)this, I18n.func_135052_a((String)"hats.gui.button.favouriteHat", (Object[])new Object[0]), TEX_FAVOURITE, btn -> {
                ((WindowHatOptions)parent).parentElement.hatLevel.isFavourite = !((WindowHatOptions)parent).parentElement.hatLevel.isFavourite;
                ((WorkspaceHats)parent.parent).notifyChanged(((WindowHatOptions)parent).parentElement.hatOrigin.setModifier(((WindowHatOptions)parent).parentElement.hatLevel));
            });
            btnToggle.setSize(20, 20);
            btnToggle.constraints().right((IConstrainable)this, Constraint.Property.Type.LEFT, 1).top((IConstrainable)btnStackLast, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(btnToggle);
            this.buttons.add((Element<?>)btnToggle);
        }

        public static void openColouriser(WorkspaceHats parent, ElementHatRender<?> parentElement) {
            WindowSetColouriser windowSetColouriser = new WindowSetColouriser(parent, parentElement);
            windowSetColouriser.pos(parentElement.getLeft(), parentElement.getTop());
            windowSetColouriser.size(parentElement.getWidth(), parentElement.getHeight());
            parent.addWindowWithHalfGreyout(windowSetColouriser);
            windowSetColouriser.init();
        }

        public static void openPersonalizer(WorkspaceHats parent, ElementHatRender<?> parentElement) {
            WindowSetAccessory windowSetAccessory = new WindowSetAccessory(parent, parentElement);
            windowSetAccessory.pos(parentElement.getLeft(), parentElement.getTop());
            windowSetAccessory.size(parentElement.getWidth(), parentElement.getHeight());
            parent.addWindowWithHalfGreyout(windowSetAccessory);
            windowSetAccessory.init();
        }

        public void renderBackground(MatrixStack stack) {
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
            int offsetTime = 2;
            if (this.age <= this.buttons.size() * offsetTime + Hats.configClient.guiAnimationTime) {
                for (int i = 0; i < this.buttons.size(); ++i) {
                    Element<?> element = this.buttons.get(i);
                    float prog = (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)(this.age - i * offsetTime) + partialTick) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f) * 90.0f));
                    float reverseProg = 1.0f - prog;
                    element.posX = (int)(21.0f * reverseProg);
                }
            }
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 375.0);
            super.func_230430_a_(stack, mouseX, mouseY, partialTick);
            stack.func_227865_b_();
            ((WindowHatOptions)((WindowHatOptions)this.parentFragment)).parentElement.parentFragment.setScissor();
            ((WindowHatOptions)this.parentFragment).parentElement.func_230430_a_(stack, mouseX, mouseY, partialTick);
            this.resetScissorToParent();
        }

        public void tick() {
            super.tick();
            ++this.age;
            int offsetTime = 2;
            if (this.age <= this.buttons.size() * offsetTime + Hats.configClient.guiAnimationTime) {
                for (Element<?> element : this.buttons) {
                    element.posX = 21;
                }
            }
        }

        public void setScissor() {
            RenderHelper.startGlScissor((int)this.getLeft(), (int)this.getTop(), (int)(this.width + ((WindowHatOptions)this.parentFragment).parentElement.getWidth()), (int)this.height);
        }
    }
}

