/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.gui.window.WindowSidebar;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.sort.HatSorter;
import me.ichun.mods.hats.common.hats.sort.SortHandler;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementToggleTextured;
import net.minecraft.client.resources.I18n;

public class WindowHatSorter
extends Window<WorkspaceHats> {
    public WindowHatSorter(WorkspaceHats parent) {
        super((IWindows)parent);
        this.disableDockingEntirely();
        this.disableDrag();
        this.disableTitle();
        this.setView(new ViewHatSorter(this));
    }

    public static class ViewHatSorter
    extends View<WindowHatSorter> {
        public ElementList<?> filters;
        public ElementList<?> sorters;

        public ViewHatSorter(@Nonnull WindowHatSorter parent) {
            super((Window)parent, "hats.gui.window.sorter.title");
            int padding = 8;
            ElementButton button = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), btn -> ((WorkspaceHats)parent.parent).removeWindow(parent));
            button.setSize(60, 20);
            button.constraints().bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(button);
            ElementTextWrapper textFilters = new ElementTextWrapper((Fragment)this);
            textFilters.setText(I18n.func_135052_a((String)"hats.gui.window.sorter.filters", (Object[])new Object[0]));
            textFilters.constraints().left((IConstrainable)this, Constraint.Property.Type.LEFT, padding).top((IConstrainable)this, Constraint.Property.Type.TOP, 4).width((IConstrainable)this, Constraint.Property.Type.WIDTH, 45);
            this.elements.add(textFilters);
            this.filters = new ElementList((Fragment)this);
            this.filters.constraints().top((IConstrainable)textFilters, Constraint.Property.Type.BOTTOM, 2).left((IConstrainable)this, Constraint.Property.Type.LEFT, padding).bottom((IConstrainable)button, Constraint.Property.Type.TOP, padding).width((IConstrainable)this, Constraint.Property.Type.WIDTH, 45);
            this.elements.add(this.filters);
            this.sorters = new ElementList((Fragment)this).setDragHandler((i, j) -> {}).setRearrangeHandler((i, j) -> {});
            this.sorters.constraints().left(this.filters, Constraint.Property.Type.RIGHT, padding).top(this.filters, Constraint.Property.Type.TOP, 0).bottom(this.filters, Constraint.Property.Type.BOTTOM, 0).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(this.sorters);
            for (HatSorter filterSorter : Hats.configClient.filterSorters) {
                this.addHatSorterToList(filterSorter.isFilter() ? this.filters : this.sorters, filterSorter, filterSorter.isInverse ? 2 : 1);
            }
            SortHandler.SORTERS.forEach((type, clz) -> {
                try {
                    HatSorter hatSorter = (HatSorter)clz.newInstance();
                    ElementList<?> elementList = hatSorter.isFilter() ? this.filters : this.sorters;
                    boolean add = true;
                    for (ElementList.Item item : elementList.items) {
                        if (!((HatSorter)item.getObject()).type().equals(hatSorter.type())) continue;
                        add = false;
                        break;
                    }
                    if (add) {
                        this.addHatSorterToList(hatSorter.isFilter() ? this.filters : this.sorters, hatSorter, 0);
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    Hats.LOGGER.error("Error creating known sorter type: {}", (Object)clz.getName());
                    e.printStackTrace();
                }
            });
            ElementTextWrapper textSorters = new ElementTextWrapper((Fragment)this);
            textSorters.setText(I18n.func_135052_a((String)"hats.gui.window.sorter.sorters", (Object[])new Object[0]));
            textSorters.constraints().left(this.sorters, Constraint.Property.Type.LEFT, 0).bottom(this.sorters, Constraint.Property.Type.TOP, 3).right(this.sorters, Constraint.Property.Type.RIGHT, 0);
            this.elements.add(textSorters);
            ElementButton button1 = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]), btn -> {
                ArrayList<HatSorter> newSorters = new ArrayList<HatSorter>();
                for (ElementList.Item item : this.filters.items) {
                    if (((ElementToggleTextured)item.getById((String)"btnDisabled")).toggleState) continue;
                    newSorters.add((HatSorter)item.getObject());
                }
                for (ElementList.Item item : this.sorters.items) {
                    if (((ElementToggleTextured)item.getById((String)"btnDisabled")).toggleState) continue;
                    newSorters.add((HatSorter)item.getObject());
                }
                ArrayList<String> filterSorterText = new ArrayList<String>();
                for (HatSorter newSorter : newSorters) {
                    String s = newSorter.type();
                    if (newSorter.isInverse) {
                        s = s + ":inverse";
                    }
                    filterSorterText.add(s);
                }
                Hats.configClient.filterSorterConfig = filterSorterText;
                Hats.configClient.save();
                ((WorkspaceHats)parent.parent).windowHatsList.getCurrentView().updateSearch("");
                ((WorkspaceHats)parent.parent).removeWindow(parent);
            });
            button1.setSize(60, 20);
            button1.constraints().right((IConstrainable)button, Constraint.Property.Type.LEFT, padding);
            this.elements.add(button1);
            ElementButton buttonTip = new ElementButton((Fragment)this, "?", btn -> {});
            buttonTip.setSize(20, 20);
            buttonTip.setTooltip(I18n.func_135052_a((String)"hats.gui.window.sorter.dragTip", (Object[])new Object[0]));
            buttonTip.constraints().left((IConstrainable)this, Constraint.Property.Type.LEFT, padding).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(buttonTip);
        }

        public void addHatSorterToList(ElementList<?> list, HatSorter filterSorter, int state) {
            ElementList.Item item = list.addItem((Object)filterSorter);
            ElementToggleTextured btnStack = new ElementToggleTextured((Fragment)item, I18n.func_135052_a((String)"hats.gui.window.sorter.disabled", (Object[])new Object[0]), WindowSidebar.ViewSidebar.TEX_CANCEL, btn -> {
                for (Element element : item.elements) {
                    if (!(element instanceof ElementToggleTextured) || element == btn) continue;
                    ((ElementToggleTextured)element).toggleState = false;
                }
                btn.toggleState = true;
                ((HatSorter)item.getObject()).isInverse = false;
            });
            btnStack.setSize(14, 14).setId("btnDisabled");
            btnStack.setToggled(state == 0);
            btnStack.constraints().right((IConstrainable)item, Constraint.Property.Type.RIGHT, item.getBorderSize());
            item.elements.add(btnStack);
            ElementToggleTextured btnStackLast = btnStack;
            btnStack = new ElementToggleTextured((Fragment)item, I18n.func_135052_a((String)"hats.gui.window.sorter.enabledInverse", (Object[])new Object[0]), WindowSidebar.ViewSidebar.TEX_RELOAD, btn -> {
                for (Element element : item.elements) {
                    if (!(element instanceof ElementToggleTextured) || element == btn) continue;
                    ((ElementToggleTextured)element).toggleState = false;
                }
                btn.toggleState = true;
                ((HatSorter)item.getObject()).isInverse = true;
            });
            btnStack.setSize(14, 14).setId("btnInverse");
            btnStack.setToggled(state == 2);
            btnStack.constraints().right((IConstrainable)btnStackLast, Constraint.Property.Type.LEFT, item.getBorderSize());
            item.elements.add(btnStack);
            btnStackLast = btnStack;
            btnStack = new ElementToggleTextured((Fragment)item, I18n.func_135052_a((String)"hats.gui.window.sorter.enabled", (Object[])new Object[0]), WindowSidebar.ViewSidebar.TEX_CONFIRM, btn -> {
                for (Element element : item.elements) {
                    if (!(element instanceof ElementToggleTextured) || element == btn) continue;
                    ((ElementToggleTextured)element).toggleState = false;
                }
                btn.toggleState = true;
                ((HatSorter)item.getObject()).isInverse = false;
            });
            btnStack.setSize(14, 14).setId("btnEnabled");
            btnStack.setToggled(state == 1);
            btnStack.constraints().right((IConstrainable)btnStackLast, Constraint.Property.Type.LEFT, item.getBorderSize());
            item.elements.add(btnStack);
            btnStackLast = btnStack;
            ElementTextWrapper wrapper = new ElementTextWrapper((Fragment)item).setText(I18n.func_135052_a((String)("hats.gui.sorter." + filterSorter.type() + ".name"), (Object[])new Object[0]));
            wrapper.setConstraint(Constraint.matchParent((IConstrained)wrapper, (IConstrainable)item, (int)item.getBorderSize()).right((IConstrainable)btnStackLast, Constraint.Property.Type.LEFT, item.getBorderSize()).bottom(null, Constraint.Property.Type.BOTTOM, 0));
            item.elements.add(wrapper);
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 375.0);
            super.func_230430_a_(stack, mouseX, mouseY, partialTick);
            stack.func_227865_b_();
        }
    }
}

