/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementButton;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class WindowTutorial
extends Window<WorkspaceHats> {
    private static final ResourceLocation TEX_ARROW = new ResourceLocation("textures/gui/container/villager2.png");
    public int age;
    public Direction direction;
    public int pointX;
    public int pointY;
    public int finalWidth;
    public int finalHeight;

    public WindowTutorial(WorkspaceHats parent, Direction dir, int pointX, int pointY, int width, int height, @Nullable Consumer<Workspace> callback, String text) {
        super((IWindows)parent);
        this.direction = dir;
        this.pointX = pointX;
        this.pointY = pointY;
        this.finalWidth = width;
        this.finalHeight = height;
        this.posX = dir == Direction.LEFT ? pointX + 30 : pointX - 30 - this.finalWidth;
        this.posY = pointY - this.finalHeight / 2;
        if (this.posX < 0) {
            this.posX = 0;
        } else if (this.posX + this.finalWidth > parent.getRight()) {
            this.posX = parent.getRight() - this.finalWidth;
        }
        if (this.posY < 0) {
            this.posY = 0;
        } else if (this.posY + this.finalHeight > parent.getBottom()) {
            this.posY = parent.getBottom() - this.finalHeight;
        }
        this.disableDockingEntirely();
        this.disableDrag();
        this.disableTitle();
        this.setView(new ViewTutorial(this, callback, text));
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        float prog = (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)this.age + partialTick) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f) * 90.0f));
        float revProg = 1.0f - prog;
        if (this.age <= Hats.configClient.guiAnimationTime) {
            this.width = (int)((float)this.finalWidth * prog);
            this.height = (int)((float)this.finalHeight * prog);
            this.resize(((WorkspaceHats)this.parent).getMinecraft(), ((WorkspaceHats)this.parent).getWidth(), ((WorkspaceHats)this.parent).getHeight());
        }
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, 375.0);
        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float sin = (float)Math.sin(Math.toRadians(((float)this.age + partialTick) / (float)Hats.configClient.guiAnimationTime * 90.0f));
        WindowTutorial.bindTexture((ResourceLocation)TEX_ARROW);
        if (this.direction == Direction.LEFT) {
            RenderHelper.draw((MatrixStack)stack, (double)(this.pointX + 2 + (int)(35.0f * revProg + 3.0f * sin)), (double)(this.pointY - 9), (double)20.0, (double)18.0, (double)0.0, (double)0.048828125, (double)0.029296875, (double)0.66796875, (double)0.703125);
        } else {
            RenderHelper.draw((MatrixStack)stack, (double)(this.pointX - 2 - 20 - (int)(35.0f * revProg + 3.0f * sin)), (double)(this.pointY - 9), (double)20.0, (double)18.0, (double)0.0, (double)0.029296875, (double)0.048828125, (double)0.66796875, (double)0.703125);
        }
        stack.func_227865_b_();
    }

    public void tick() {
        super.tick();
        ++this.age;
        if (this.age == Hats.configClient.guiAnimationTime + 1) {
            this.width = this.finalWidth;
            this.height = this.finalHeight;
            this.resize(((WorkspaceHats)this.parent).getMinecraft(), ((WorkspaceHats)this.parent).getWidth(), ((WorkspaceHats)this.parent).getHeight());
        }
    }

    public static class ViewTutorial
    extends View<WindowTutorial> {
        public ViewTutorial(@Nonnull WindowTutorial parent, @Nullable Consumer<Workspace> callback, String text) {
            super((Window)parent, "hats.gui.tutorial.title");
            int padding = 3;
            ElementTextWrapper text1 = new ElementTextWrapper((Fragment)this);
            text1.setText(text);
            text1.constraints().top((IConstrainable)this, Constraint.Property.Type.TOP, padding).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, 30).left((IConstrainable)this, Constraint.Property.Type.LEFT, 10).right((IConstrainable)this, Constraint.Property.Type.RIGHT, 10);
            this.elements.add(text1);
            ElementButton button = new ElementButton((Fragment)this, I18n.func_135052_a((String)"gui.ok", (Object[])new Object[0]), elementClickable -> {
                ((WorkspaceHats)parent.parent).removeWindow(parent);
                if (callback != null) {
                    callback.accept((Workspace)parent.parent);
                }
            });
            button.setSize(60, 20);
            button.constraints().bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(button);
        }
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

