/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.EventCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;

public class LayerHat<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public LayerHat() {
        super((IEntityRenderer)Minecraft.func_71410_x().func_175598_ae().field_178637_m);
    }

    public void render(MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn, LivingEntity living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (Hats.eventHandlerClient.renderCount >= Hats.configClient.maxHatRenders && !(living instanceof PlayerEntity) || living.field_70128_L) {
            return;
        }
        HeadInfo helper = HeadHandler.getHelper(living.getClass());
        if (helper != null) {
            EntityRenderer render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)living);
            if (!(render instanceof LivingRenderer)) {
                return;
            }
            if (HatHandler.hasBeenRandomlyAllocated(living)) {
                HatsSavedData.HatPart hatPart = HatHandler.getHatPart(living);
                if (hatPart.isAHat()) {
                    int overlay = LivingRenderer.func_229117_c_((LivingEntity)living, (float)0.0f);
                    LayerHat.renderHat(helper, (LivingRenderer)render, stack, bufferIn, packedLightIn, overlay, living, partialTicks, hatPart);
                }
            } else if (Hats.eventHandlerClient.serverHasMod) {
                Hats.eventHandlerClient.requestHatDetails(living);
                HatHandler.assignNoHat(living);
            } else if (Minecraft.func_71410_x().field_71439_g.field_70173_aa > 100) {
                HatHandler.assignHatClient(living);
            }
        }
    }

    public static boolean renderHat(HeadInfo parentHelper, LivingRenderer<?, ?> renderer, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn, LivingEntity living, float partialTicks, HatsSavedData.HatPart hatDetails) {
        if (!parentHelper.setup(living, renderer)) {
            return false;
        }
        int headCount = parentHelper.getHeadCount(living);
        boolean flag = false;
        for (int headIndex = 0; headIndex < headCount; ++headIndex) {
            HatInfo hatInfo;
            float hatScale;
            HeadInfo helper = parentHelper.getHeadInfo(living, headIndex);
            if (helper.noTopInfo.booleanValue()) continue;
            boolean isDragon = living instanceof EnderDragonEntity;
            if (!isDragon) {
                helper.setHeadModel(living, renderer);
                if (helper.headModel == null) continue;
            }
            if (living.func_82150_aj() && helper.affectedByInvisibility(living, -1) && !Hats.eventHandlerClient.forceRenderWhenInvisible || (hatScale = helper.getHatScale(living, stack, partialTicks, headIndex)) <= 0.0f) continue;
            hatScale *= 1.005f;
            stack.func_227860_a_();
            helper.correctPosition(living, stack, partialTicks);
            if (!isDragon) {
                helper.preChildEntHeadRenderCalls(living, stack, renderer);
                float[] joint = helper.getHeadJointOffset(living, stack, partialTicks, headIndex);
                stack.func_227861_a_((double)(-joint[0]), (double)(-joint[1]), (double)(-joint[2]));
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(helper.getHeadRoll(living, stack, partialTicks, headIndex, -1)));
                stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getHeadYaw(living, stack, partialTicks, headIndex, -1)));
                stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getHeadPitch(living, stack, partialTicks, headIndex, -1)));
                helper.postHeadTranslation(living, stack, partialTicks);
            }
            float[] headPoint = helper.getHatOffsetFromJoint(living, stack, partialTicks, headIndex);
            stack.func_227861_a_((double)(-headPoint[0]), (double)(-headPoint[1] - 0.00225f), (double)(-headPoint[2]));
            float[] armorOffset = helper.getHeadArmorOffset(living, stack, partialTicks, headIndex);
            if (armorOffset != null) {
                stack.func_227861_a_((double)(-armorOffset[0]), (double)(-armorOffset[1]), (double)(-armorOffset[2]));
            }
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(helper.getHatYaw(living, stack, partialTicks, headIndex)));
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(helper.getHatPitch(living, stack, partialTicks, headIndex)));
            stack.func_227862_a_(hatScale, hatScale, hatScale);
            float armorScale = helper.getHeadArmorScale(living, stack, partialTicks, headIndex);
            if (armorScale != 1.0f) {
                stack.func_227862_a_(armorScale, armorScale, armorScale);
            }
            if (EventCalendar.isEventDay() && iChunUtil.configClient.easterEgg) {
                hatDetails = hatDetails.createCopy();
                hatDetails.eventDay(living.field_70173_aa, partialTicks);
            }
            if ((hatInfo = HatResourceHandler.getInfoAndSetToPart(hatDetails)) != null) {
                hatInfo.render(stack, bufferIn, packedLightIn, packedOverlayIn, true);
                ++Hats.eventHandlerClient.renderCount;
                flag = true;
            } else if (Hats.eventHandlerClient.serverHasMod) {
                Hats.eventHandlerClient.showSyncToast();
            }
            stack.func_227865_b_();
        }
        return flag;
    }
}

