/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelHat
extends Model {
    @Nonnull
    public final HatInfo info;
    public ArrayList<ModelRenderer> models = new ArrayList();
    public HashMap<ModelRenderer, Project.Part> partMap = new HashMap();

    public ModelHat(@Nonnull HatInfo info) {
        super(RenderType::func_228642_d_);
        this.info = info;
        this.field_78090_t = info.project.texWidth;
        this.field_78089_u = info.project.texHeight;
        info.project.parts.forEach(part -> this.populateModel((Collection<? super ModelRenderer>)this.models, (Project.Part)part));
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int light, int overlay, float r, float g, float b, float alpha) {
        this.partMap.forEach((modelRenderer, part) -> {
            modelRenderer.field_78806_j = part.showModel;
        });
        for (ModelRenderer model : this.models) {
            model.func_228309_a_(matrixStack, iVertexBuilder, light, overlay, r, g, b, alpha);
        }
    }

    public void populateModel(Collection<? super ModelRenderer> parts, Project.Part part) {
        int[] dims = part.getProjectTextureDims();
        if (!part.matchProject) {
            dims[0] = part.texWidth;
            dims[1] = part.texHeight;
        }
        ModelRenderer modelPart = new ModelRenderer(dims[0], dims[1], part.texOffX, part.texOffY);
        modelPart.field_78800_c = part.rotPX;
        modelPart.field_78797_d = part.rotPY;
        modelPart.field_78798_e = part.rotPZ;
        modelPart.field_78795_f = (float)Math.toRadians(part.rotAX);
        modelPart.field_78796_g = (float)Math.toRadians(part.rotAY);
        modelPart.field_78808_h = (float)Math.toRadians(part.rotAZ);
        modelPart.field_78809_i = part.mirror;
        modelPart.field_78806_j = part.showModel;
        int texOffX = modelPart.field_78803_o;
        int texOffY = modelPart.field_78813_p;
        for (Project.Part.Box box : part.boxes) {
            modelPart.func_78784_a(texOffX + box.texOffX, texOffY + box.texOffY);
            modelPart.func_228302_a_(box.posX, box.posY, box.posZ, box.dimX, box.dimY, box.dimZ, box.expandX, box.expandY, box.expandZ);
        }
        modelPart.func_78784_a(texOffX, texOffY);
        part.children.forEach(part1 -> this.populateModel((Collection<? super ModelRenderer>)modelPart.field_78805_m, (Project.Part)part1));
        parts.add((ModelRenderer)modelPart);
        this.partMap.put(modelPart, part);
    }
}

