/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common;

import javax.annotation.Nullable;
import me.ichun.mods.hats.client.config.ConfigClient;
import me.ichun.mods.hats.client.core.EventHandlerClient;
import me.ichun.mods.hats.client.entity.EntityDummy;
import me.ichun.mods.hats.client.module.tabula.HatsTabulaPlugin;
import me.ichun.mods.hats.client.render.ItemRenderHatLauncher;
import me.ichun.mods.hats.client.render.RenderHatEntity;
import me.ichun.mods.hats.common.command.HatInfosArgument;
import me.ichun.mods.hats.common.config.ConfigServer;
import me.ichun.mods.hats.common.core.EventHandlerServer;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.hats.advancement.Advancements;
import me.ichun.mods.hats.common.item.ItemHatLauncher;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketEntityHatEntityDetails;
import me.ichun.mods.hats.common.packet.PacketGiveHat;
import me.ichun.mods.hats.common.packet.PacketHatCustomisation;
import me.ichun.mods.hats.common.packet.PacketHatFragment;
import me.ichun.mods.hats.common.packet.PacketHatLauncherCustomisation;
import me.ichun.mods.hats.common.packet.PacketHatsList;
import me.ichun.mods.hats.common.packet.PacketHatsListResponse;
import me.ichun.mods.hats.common.packet.PacketHeadInfos;
import me.ichun.mods.hats.common.packet.PacketNewHatPart;
import me.ichun.mods.hats.common.packet.PacketPing;
import me.ichun.mods.hats.common.packet.PacketRehatify;
import me.ichun.mods.hats.common.packet.PacketRequestEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketRequestHeadInfos;
import me.ichun.mods.hats.common.packet.PacketUpdateHats;
import me.ichun.mods.hats.common.thread.ThreadReadHats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.client.item.ItemEffectHandler;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.client.model.item.ItemModelRenderer;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hats")
public class Hats {
    public static final String MOD_NAME = "Hats";
    public static final String MOD_ID = "hats";
    public static final String PROTOCOL = "1";
    public static final Logger LOGGER = LogManager.getLogger();
    public static ConfigClient configClient;
    public static ConfigServer configServer;
    public static EventHandlerClient eventHandlerClient;
    public static EventHandlerServer eventHandlerServer;
    public static PacketChannel channel;
    private static ThreadReadHats threadReadHats;

    public Hats() {
        if (!HatResourceHandler.init()) {
            return;
        }
        configServer = (ConfigServer)new ConfigServer().init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityTypes.REGISTRY.register(bus);
        Items.REGISTRY.register(bus);
        Sounds.REGISTRY.register(bus);
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::finishLoading);
        eventHandlerServer = new EventHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerServer);
        channel = new PacketChannel(new ResourceLocation(MOD_ID, "channel"), PROTOCOL, true, false, new Class[]{PacketPing.class, PacketRequestEntityHatDetails.class, PacketEntityHatDetails.class, PacketRequestHeadInfos.class, PacketHeadInfos.class, PacketNewHatPart.class, PacketUpdateHats.class, PacketHatCustomisation.class, PacketEntityHatEntityDetails.class, PacketRehatify.class, PacketHatLauncherCustomisation.class, PacketHatsList.class, PacketHatsListResponse.class, PacketHatFragment.class, PacketGiveHat.class});
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            configClient = (ConfigClient)new ConfigClient().init();
            EntityDummy.init(bus);
            bus.addListener(this::onClientSetup);
            bus.addListener(this::enqueueIMC);
            bus.addListener(this::onModelBake);
            eventHandlerClient = new EventHandlerClient();
            MinecraftForge.EVENT_BUS.register((Object)eventHandlerClient);
            ItemEffectHandler.init();
            ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> me.ichun.mods.ichunutil.client.core.EventHandlerClient::getConfigGui);
        });
        threadReadHats = new ThreadReadHats();
        threadReadHats.start();
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(HatsSavedData.HatPart.class, (Capability.IStorage)new Capability.IStorage<HatsSavedData.HatPart>(){

            @Nullable
            public INBT writeNBT(Capability<HatsSavedData.HatPart> capability, HatsSavedData.HatPart instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<HatsSavedData.HatPart> capability, HatsSavedData.HatPart instance, Direction side, INBT nbt) {
            }
        }, () -> null);
        Advancements.CriteriaTriggers.init();
        ArgumentTypes.func_218136_a((String)"hats:hat", HatInfosArgument.class, (IArgumentSerializer)new HatInfosArgument.Serializer());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup(FMLClientSetupEvent event) {
        Hats.eventHandlerClient.keyBindHats = new KeyBind(new KeyBinding("hats.key.hatsMenu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(72), "key.categories.ui"), keyBind -> eventHandlerClient.openHatsMenu(), null);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)EntityTypes.HAT.get()), (IRenderFactory)new RenderHatEntity.RenderFactory());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"tabula", (String)"plugin", HatsTabulaPlugin::new);
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        if (Hats.threadReadHats.latch.getCount() > 0L) {
            LOGGER.info("Waiting for file reader thread to finish");
            try {
                Hats.threadReadHats.latch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Got interrupted while waiting for FileReaderThread to finish");
                e.printStackTrace();
            }
        }
        threadReadHats = null;
        HeadHandler.init();
        if (FMLEnvironment.dist.isClient()) {
            eventHandlerClient.addLayers();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().put(new ModelResourceLocation("hats:hat_launcher", "inventory"), new ItemModelRenderer((ItemStackTileEntityRenderer)ItemRenderHatLauncher.INSTANCE));
    }

    public static class Sounds {
        private static final DeferredRegister<SoundEvent> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"hats");
        public static final RegistryObject<SoundEvent> POOF = REGISTRY.register("poof", () -> new SoundEvent(new ResourceLocation(Hats.MOD_ID, "poof")));
        public static final RegistryObject<SoundEvent> TUBE = REGISTRY.register("tube", () -> new SoundEvent(new ResourceLocation(Hats.MOD_ID, "tube")));
        public static final RegistryObject<SoundEvent> BONK = REGISTRY.register("bonk", () -> new SoundEvent(new ResourceLocation(Hats.MOD_ID, "bonk")));
    }

    public static class Items {
        private static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hats");
        public static final RegistryObject<ItemHatLauncher> HAT_LAUNCHER = REGISTRY.register("hat_launcher", () -> new ItemHatLauncher(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i)));
    }

    public static class EntityTypes {
        private static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"hats");
        public static final RegistryObject<EntityType<EntityHat>> HAT = REGISTRY.register("hat", () -> EntityType.Builder.func_220322_a(EntityHat::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.1f, 0.1f).setTrackingRange(64).setUpdateInterval(20).setShouldReceiveVelocityUpdates(true).func_206830_a("an entity from Hats. Ignore this."));
    }
}

