/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.hats;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.EnumRarity;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatPool;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.hats.advancement.Advancements;
import me.ichun.mods.hats.common.item.ItemHatLauncher;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketNewHatPart;
import me.ichun.mods.hats.common.packet.PacketUpdateHats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import me.ichun.mods.ichunutil.common.entity.util.EntityHelper;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.item.DualHandedItem;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class HatHandler {
    public static final EnumMap<EnumRarity, ArrayList<HatPool>> HAT_POOLS = new EnumMap(EnumRarity.class);
    public static final Random RAND = new Random();
    private static HatsSavedData saveData;

    public static synchronized void allocateHatPools() {
        HAT_POOLS.clear();
        HashMap<String, HatPool> poolsByName = new HashMap<String, HatPool>();
        for (Map.Entry<String, HatInfo> entry : HatResourceHandler.HATS.entrySet()) {
            String hatName = entry.getKey();
            HatInfo hatInfo = entry.getValue();
            HatPool pool = hatInfo.forcedPool != null ? poolsByName.computeIfAbsent(hatInfo.forcedPool, k -> new HatPool()) : poolsByName.computeIfAbsent(hatName, k -> new HatPool());
            pool.addHatToPool(hatInfo);
            if (hatInfo.forcedRarity == null) continue;
            pool.forcedRarity = hatInfo.forcedRarity;
        }
        for (Map.Entry<String, HatInfo> entry : poolsByName.entrySet()) {
            HatPool pool = (HatPool)((Object)entry.getValue());
            if (pool.forcedRarity != null) {
                ArrayList arrayList = HAT_POOLS.computeIfAbsent(pool.forcedRarity, k -> new ArrayList());
                arrayList.add(pool);
                continue;
            }
            RAND.setSeed((long)Math.abs((Hats.configServer.randSeed + entry.getKey()).hashCode()) * 154041013L);
            EnumRarity enumRarity = HatHandler.getRarityForChance(RAND.nextDouble());
            ArrayList hats = HAT_POOLS.computeIfAbsent(enumRarity, k -> new ArrayList());
            for (HatInfo hatInfo : pool.hatsInPool) {
                hatInfo.setRarity(enumRarity);
            }
            hats.add(pool);
        }
        for (Iterator<Map.Entry<String, HatInfo>> iterator : EnumRarity.values()) {
            HAT_POOLS.computeIfAbsent((EnumRarity)((Object)iterator), (Function<EnumRarity, ArrayList<HatPool>>)((Function<EnumRarity, ArrayList>)k -> new ArrayList()));
        }
        Hats.LOGGER.info("Allocated Hat Pools.");
    }

    public static EnumRarity getRarityForChance(double chance) {
        EnumRarity[] rarities = EnumRarity.values();
        for (int i = 0; i < Hats.configServer.rarityMeasure.size(); ++i) {
            if (!(chance < Hats.configServer.rarityMeasure.get(i))) continue;
            return rarities[i];
        }
        return EnumRarity.COMMON;
    }

    public static double getHatChance(LivingEntity ent) {
        if (Hats.configServer.entityOverrideChanceParsed.containsKey(ent.func_200600_R().getRegistryName())) {
            return (float)Hats.configServer.entityOverrideChanceParsed.get(ent.func_200600_R().getRegistryName()).intValue() / 100.0f;
        }
        double chance = Hats.configServer.hatChance;
        HeadInfo info = HeadHandler.getHelper(ent.getClass());
        if (info != null && info.isBoss.booleanValue()) {
            chance += Hats.configServer.bossHatChanceBonus;
        }
        return chance;
    }

    public static boolean canWearHat(LivingEntity ent) {
        HeadInfo info = HeadHandler.getHelper(ent.getClass());
        if (info != null && !info.noTopInfo.booleanValue()) {
            for (String disabledName : Hats.configServer.disabledMobs) {
                if (!new ResourceLocation(disabledName).equals((Object)ent.func_200600_R().getRegistryName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static HatsSavedData.HatPart getHatPart(LivingEntity ent) {
        return (HatsSavedData.HatPart)ent.getCapability(HatsSavedData.HatPart.CAPABILITY_INSTANCE).orElseThrow(() -> new IllegalArgumentException("Entity " + ent.getClass().getSimpleName() + ":" + ent.func_200200_C_().func_150261_e() + " has no hat capabilities"));
    }

    public static void checkValidity(LivingEntity ent) {
        HatsSavedData.HatPart part = HatHandler.getHatPart(ent);
        if (!HatResourceHandler.HATS.containsKey(part.name)) {
            part.read(new HatsSavedData.HatPart().write(new CompoundNBT()));
        }
    }

    public static boolean hasBeenRandomlyAllocated(LivingEntity ent) {
        return HatHandler.getHatPart((LivingEntity)ent).count >= 0;
    }

    public static void assignHat(LivingEntity ent) {
        HatsSavedData.HatPart hatPart = HatHandler.getHatPart(ent);
        RAND.setSeed((long)Math.abs((Hats.configServer.randSeed + ent.func_110124_au()).hashCode()) * 425480085L);
        double chance = RAND.nextDouble();
        HeadInfo info = HeadHandler.getHelper(ent.getClass());
        if (info != null && info.isBoss.booleanValue()) {
            chance += Hats.configServer.bossRarityBonus;
        }
        EnumRarity rarity = HatHandler.getRarityForChance(chance);
        ArrayList<HatPool> hatPools = HAT_POOLS.get((Object)rarity);
        HatPool pool = hatPools.get(RAND.nextInt(hatPools.size()));
        HatInfo hatInfo = pool.getRandomHat();
        hatPart.name = hatInfo.name;
        hatPart.count = info != null && info.setup(ent) ? info.getHeadCount(ent) : 1;
        hatPart.isShowing = true;
        hatInfo.assignAccessoriesToPart(hatPart, ent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void assignHatClient(LivingEntity ent) {
        RAND.setSeed((long)Math.abs((Minecraft.func_71410_x().func_110432_I().func_111285_a() + ent.func_110124_au()).hashCode()) * 425480085L);
        if (RAND.nextDouble() < Hats.configClient.hatChance) {
            HatsSavedData.HatPart hatPart = HatHandler.getHatPart(ent);
            ArrayList<HatInfo> infos = new ArrayList<HatInfo>(HatResourceHandler.HATS.values());
            if (!infos.isEmpty()) {
                HatInfo hatInfo = infos.get(RAND.nextInt(infos.size()));
                hatPart.name = hatInfo.name;
                hatPart.count = 1;
                hatPart.isShowing = true;
                hatInfo.assignAccessoriesToPartClient(hatPart, ent);
                if (ent == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71462_r instanceof WorkspaceHats) {
                    ((WorkspaceHats)Minecraft.func_71410_x().field_71462_r).refreshHats();
                }
            } else {
                HatHandler.assignNoHat(ent);
            }
        } else {
            HatHandler.assignNoHat(ent);
        }
    }

    public static void assignSpecificHat(LivingEntity ent, HatsSavedData.HatPart part) {
        HatsSavedData.HatPart hatPart = HatHandler.getHatPart(ent);
        if (part != null) {
            hatPart.copy(part);
        } else {
            hatPart.name = "";
            hatPart.count = 0;
        }
    }

    public static void assignNoHat(LivingEntity ent) {
        HatHandler.assignSpecificHat(ent, null);
    }

    public static void setSaveData(HatsSavedData data) {
        saveData = data;
    }

    private static void addNamesOfLackingParts(ArrayList<String> names, @Nullable HatsSavedData.HatPart source, @Nonnull HatsSavedData.HatPart target) {
        ArrayList<String> parts = new ArrayList<String>();
        for (HatsSavedData.HatPart hatPart : target.hatParts) {
            parts.add(hatPart.name);
        }
        if (source != null) {
            for (HatsSavedData.HatPart part : source.hatParts) {
                parts.remove(part.name);
            }
        }
        names.addAll(parts);
        for (HatsSavedData.HatPart nextTarget : target.hatParts) {
            HatsSavedData.HatPart nextSource = null;
            if (source != null) {
                for (HatsSavedData.HatPart part : source.hatParts) {
                    if (!part.name.equals(nextTarget.name)) continue;
                    nextSource = part;
                }
            }
            HatHandler.addNamesOfLackingParts(names, nextSource, nextTarget);
        }
    }

    public static void markSaveDirty() {
        saveData.func_76185_a();
    }

    public static void addHat(ServerPlayerEntity player, HatsSavedData.HatPart hatToAdd) {
        HatInfo info = HatResourceHandler.HATS.get(hatToAdd.name);
        if (info != null) {
            HatsSavedData.HatPart mobHat = hatToAdd.createCopy();
            hatToAdd.hideAll();
            hatToAdd.isShowing = true;
            boolean foundBase = false;
            HatsSavedData.HatPart inventoryHat = null;
            HatsSavedData.PlayerHatData playerHatData = HatHandler.saveData.playerHats.computeIfAbsent(player.func_146103_bH().getId(), k -> new HatsSavedData.PlayerHatData(player.func_146103_bH().getId()));
            for (HatsSavedData.HatPart hatPart : playerHatData.hatParts) {
                if (!hatToAdd.name.equals(hatPart.name)) continue;
                inventoryHat = hatPart;
                foundBase = true;
                break;
            }
            if (inventoryHat == null) {
                inventoryHat = new HatsSavedData.HatPart(hatToAdd.name).setNew();
                playerHatData.hatParts.add(inventoryHat);
                inventoryHat.count = 0;
            }
            ArrayList<String> names = new ArrayList<String>();
            names.add(info.getDisplayName());
            ArrayList<String> accessoryNames = new ArrayList<String>();
            HatHandler.addNamesOfLackingParts(accessoryNames, inventoryHat, hatToAdd);
            inventoryHat.add(hatToAdd);
            Advancements.triggerHatCount(player, inventoryHat.count);
            if (!accessoryNames.isEmpty()) {
                for (String accessoryName : accessoryNames) {
                    HatInfo accessoryInfo = info.getInfoFor(accessoryName);
                    if (accessoryInfo == null) continue;
                    String dispName = accessoryInfo.getDisplayName();
                    names.add("- " + dispName);
                    if (accessoryInfo.accessoryParent == null) continue;
                    Advancements.CriteriaTriggers.ACCESSORY_IN_ACCESSORY.trigger(player);
                }
            }
            if (!foundBase || !accessoryNames.isEmpty()) {
                inventoryHat.setNew();
                Advancements.checkHatsAndAccessoriesUnlocked(player);
                if (inventoryHat.hatParts.size() >= 3) {
                    Advancements.CriteriaTriggers.HAT_WITH_THREE_OR_MORE_ACCESSORIES.trigger(player);
                }
                if (Hats.configServer.sendNewHatToastPrompt) {
                    Hats.channel.sendTo((AbstractPacket)new PacketNewHatPart(!foundBase, mobHat, names), player);
                }
            }
            Hats.channel.sendTo((AbstractPacket)new PacketUpdateHats(inventoryHat.write(new CompoundNBT()), false), player);
            HatHandler.markSaveDirty();
        }
    }

    public static ArrayList<HatsSavedData.HatPart> getHatSource(PlayerEntity player) {
        ArrayList<HatsSavedData.HatPart> source = new ArrayList<HatsSavedData.HatPart>();
        if (HatHandler.useInventory(player)) {
            ArrayList<HatsSavedData.HatPart> allHats = HatResourceHandler.getAllHatsAsHatParts(0);
            for (HatsSavedData.HatPart hat : allHats) {
                hat.setBrightnessZero();
                source.add(hat);
            }
        } else {
            for (HatsSavedData.HatPart hatPart : HatResourceHandler.HAT_PARTS) {
                source.add(hatPart.createCopy());
            }
        }
        HatResourceHandler.combineLists(source, HatHandler.getPlayerInventory(player));
        return source;
    }

    public static ArrayList<HatsSavedData.HatPart> getPlayerInventory(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            if (Hats.eventHandlerClient.hatsInventory == null) {
                Hats.eventHandlerClient.hatsInventory = new HatsSavedData.PlayerHatData(player.func_146103_bH().getId());
            }
            return Hats.eventHandlerClient.hatsInventory.hatParts;
        }
        return HatHandler.saveData.playerHats.computeIfAbsent((UUID)player.func_146103_bH().getId(), (Function<UUID, HatsSavedData.PlayerHatData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getPlayerInventory$7(net.minecraft.entity.player.PlayerEntity java.util.UUID ), (Ljava/util/UUID;)Lme/ichun/mods/hats/common/world/HatsSavedData$PlayerHatData;)((PlayerEntity)player)).hatParts;
    }

    public static ArrayList<HatsSavedData.HatPart> getPlayerInventoryCopy(PlayerEntity player) {
        ArrayList<HatsSavedData.HatPart> copy = new ArrayList<HatsSavedData.HatPart>();
        ArrayList<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventory(player);
        for (HatsSavedData.HatPart hatPart : playerInventory) {
            copy.add(hatPart.createCopy());
        }
        return copy;
    }

    public static void setPlayerHatCustomisation(ServerPlayerEntity player, ArrayList<HatsSavedData.HatPart> customisedHats, @Nullable HatsSavedData.HatPart hatChange) {
        if (hatChange != null) {
            HatHandler.setPlayerHat(player, hatChange);
        }
        if (!customisedHats.isEmpty()) {
            HatsSavedData.PlayerHatData playerHatData = HatHandler.saveData.playerHats.computeIfAbsent(player.func_146103_bH().getId(), k -> new HatsSavedData.PlayerHatData(player.func_146103_bH().getId()));
            for (HatsSavedData.HatPart hatPart : playerHatData.hatParts) {
                for (int i = customisedHats.size() - 1; i >= 0; --i) {
                    HatsSavedData.HatPart customisedHat = customisedHats.get(i);
                    if (!hatPart.copyPersonalisation(customisedHat)) continue;
                    customisedHats.remove(i);
                }
            }
            for (HatsSavedData.HatPart customisedHat : customisedHats) {
                customisedHat.setCountOfAllTo(0);
                playerHatData.hatParts.add(customisedHat);
            }
            HatHandler.markSaveDirty();
        }
    }

    public static void setPlayerHat(ServerPlayerEntity player, HatsSavedData.HatPart part) {
        HatHandler.assignSpecificHat((LivingEntity)player, part);
        HashMap<Integer, HatsSavedData.HatPart> deets = new HashMap<Integer, HatsSavedData.HatPart>();
        deets.put(player.func_145782_y(), part);
        Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(deets), PacketDistributor.TRACKING_ENTITY.with(() -> player));
        if (part.isAHat()) {
            Advancements.CriteriaTriggers.WEAR_HAT.trigger(player);
            boolean accessorised = false;
            boolean colourised = false;
            block0: for (HatsSavedData.HatPart hatPart : part.hatParts) {
                if (!hatPart.isShowing) continue;
                if (!accessorised) {
                    accessorised = true;
                    Advancements.CriteriaTriggers.WEAR_HAT_WITH_ACCESSORY.trigger(player);
                }
                if (!colourised) {
                    for (float v : hatPart.hsbiser) {
                        if (v == 0.0f) continue;
                        colourised = true;
                        break;
                    }
                }
                if (colourised) continue;
                for (float v : hatPart.colouriser) {
                    if (v == 0.0f) continue;
                    colourised = true;
                    continue block0;
                }
            }
            if (!colourised) {
                for (Object v : (Object)part.hsbiser) {
                    if (v == 0.0f) continue;
                    colourised = true;
                    break;
                }
            }
            if (!colourised) {
                for (Object v : (Object)part.colouriser) {
                    if (v == 0.0f) continue;
                    colourised = true;
                    break;
                }
            }
            if (colourised) {
                Advancements.CriteriaTriggers.COLOURISE_HAT.trigger(player);
            }
        }
    }

    @Nonnull
    public static CompoundNBT getPlayerHatsNBT(PlayerEntity player) {
        if (saveData == null) {
            Hats.LOGGER.error("We're trying to get the save data for a player without having loaded the save! Player: {}", (Object)player.func_200200_C_());
            Thread.dumpStack();
            return new CompoundNBT();
        }
        HatsSavedData.PlayerHatData playerHatData = HatHandler.saveData.playerHats.get(player.func_146103_bH().getId());
        if (playerHatData == null) {
            playerHatData = new HatsSavedData.PlayerHatData(player.func_146103_bH().getId());
            ArrayList<HatPool> hatPools = HAT_POOLS.get((Object)EnumRarity.LEGENDARY);
            for (HatPool hatPool : hatPools) {
                if (hatPool.forcedRarity != EnumRarity.LEGENDARY) continue;
                for (HatInfo hatInfo : hatPool.hatsInPool) {
                    if (hatInfo.contributorUUID == null || !hatInfo.contributorUUID.equals(player.func_146103_bH().getId())) continue;
                    HatsSavedData.HatPart part = new HatsSavedData.HatPart(hatInfo.name);
                    part.isShowing = true;
                    playerHatData.hatParts.add(part);
                }
            }
            HatHandler.saveData.playerHats.put(player.func_146103_bH().getId(), playerHatData);
        }
        return playerHatData.write(new CompoundNBT());
    }

    public static boolean useInventory(@Nonnull PlayerEntity player) {
        return !(player.field_70170_p.field_72995_K && !Hats.eventHandlerClient.serverHasMod || player.func_184812_l_() && !Hats.configServer.enableCreativeModeHatHunting || EntityHelper.hasCompletedAdvancement((ResourceLocation)Advancements.ALL_VARIANTS, (PlayerEntity)player));
    }

    public static HatsSavedData.HatPart getHatPart(ItemStack is) {
        return (HatsSavedData.HatPart)is.getCapability(HatsSavedData.HatPart.CAPABILITY_INSTANCE).orElseThrow(() -> new IllegalArgumentException("Item " + is.toString() + " has no hat capabilities"));
    }

    public static void setHatPart(ItemStack is, @Nonnull HatsSavedData.HatPart part) {
        HatHandler.getHatPart(is).copy(part);
        is.func_196082_o().func_218657_a("hats_hatPart", (INBT)part.write(new CompoundNBT()));
    }

    @Nullable
    public static HatsSavedData.HatPart getRandomHat(PlayerEntity player) {
        HatInfo info;
        HatsSavedData.HatPart part = null;
        ArrayList source = HatHandler.getHatSource(player);
        if (!source.isEmpty()) {
            if (HatHandler.useInventory(player)) {
                source = source.stream().filter(hatPart -> hatPart.count > 0).collect(Collectors.toCollection(ArrayList::new));
                HatsSavedData.HatPart currentlyWearing = HatHandler.getHatPart((LivingEntity)player);
                if (!source.isEmpty()) {
                    int tries = 0;
                    while (tries++ < 10) {
                        HatsSavedData.HatPart oriHatPart = (HatsSavedData.HatPart)source.get(player.func_70681_au().nextInt(source.size()));
                        HatsSavedData.HatPart copyHatPart = oriHatPart.createCopy();
                        copyHatPart.minusByOne(currentlyWearing);
                        if (copyHatPart.count <= 0) continue;
                        HatsSavedData.HatPart partToReturn = copyHatPart.createRandom(player.func_70681_au());
                        oriHatPart.minusByOne(partToReturn);
                        part = partToReturn;
                        HatHandler.markSaveDirty();
                        break;
                    }
                }
            } else {
                part = source.get(player.func_70681_au().nextInt(source.size())).createRandom(player.func_70681_au());
            }
        }
        if (part != null && (info = HatResourceHandler.getInfo(part)) != null) {
            HatHandler.resolvePartConflicts(part, info, player.func_70681_au());
        }
        return part;
    }

    private static void resolvePartConflicts(HatsSavedData.HatPart part, HatInfo info, Random random) {
        HashMap<HatsSavedData.HatPart, HatInfo> parts = new HashMap<HatsSavedData.HatPart, HatInfo>();
        HashMap<String, ArrayList> conflicts = new HashMap<String, ArrayList>();
        for (HatsSavedData.HatPart hatPart : part.hatParts) {
            HatInfo accessory = info.getInfoFor(hatPart.name);
            if (accessory == null) continue;
            parts.put(hatPart, accessory);
            if (accessory.accessoryLayer.isEmpty()) continue;
            for (String layer : accessory.accessoryLayer) {
                conflicts.computeIfAbsent(layer, k -> new ArrayList()).add(accessory);
            }
        }
        conflicts.entrySet().removeIf(entry -> ((ArrayList)entry.getValue()).size() <= 1);
        for (ArrayList conflictAccessories : conflicts.values()) {
            while (conflictAccessories.size() > 1) {
                HatInfo acc = (HatInfo)conflictAccessories.get(random.nextInt(conflictAccessories.size()));
                part.remove(acc.getAsHatPart(1));
                conflictAccessories.remove(acc);
            }
        }
        for (HatsSavedData.HatPart hatPart : part.hatParts) {
            HatHandler.resolvePartConflicts(hatPart, (HatInfo)parts.get(hatPart), random);
        }
    }

    public static void removeOneFromInventory(ServerPlayerEntity player, HatsSavedData.HatPart part) {
        ArrayList<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventory((PlayerEntity)player);
        for (HatsSavedData.HatPart hatPart : playerInventory) {
            if (!hatPart.minusByOne(part)) continue;
            Hats.channel.sendTo((AbstractPacket)new PacketUpdateHats(hatPart.write(new CompoundNBT()), false), player);
            HatHandler.markSaveDirty();
            break;
        }
    }

    public static void setHatLauncherCustomisation(ServerPlayerEntity player, HatsSavedData.HatPart newHat) {
        ItemStack is = DualHandedItem.getUsableDualHandedItem((LivingEntity)player);
        if (is.func_77973_b() instanceof ItemHatLauncher) {
            HatsSavedData.HatPart part = newHat.createCopy();
            part.removeHiddenChildren();
            part.setCountOfAllTo(1);
            HatHandler.setHatPart(is, part);
            player.field_71071_by.func_70296_d();
        }
    }

    public static boolean playerHasHat(PlayerEntity player, HatsSavedData.HatPart part, boolean minusWearing) {
        if (HatHandler.useInventory(player)) {
            ArrayList<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventoryCopy(player);
            HatsSavedData.HatPart entityPart = HatHandler.getHatPart((LivingEntity)player);
            for (HatsSavedData.HatPart hatPart : playerInventory) {
                if (minusWearing) {
                    hatPart.minusByOne(entityPart);
                }
                if (!hatPart.hasFullPart(part)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ HatsSavedData.PlayerHatData lambda$getPlayerInventory$7(PlayerEntity player, UUID k) {
        return new HatsSavedData.PlayerHatData(player.func_146103_bH().getId());
    }
}

