/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.hats.common.hats.HatHandler;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class HatsSavedData
extends WorldSavedData {
    public static final String ID = "hats_save";
    public HashMap<UUID, PlayerHatData> playerHats = new HashMap();

    public HatsSavedData() {
        super(ID);
    }

    public void func_76184_a(CompoundNBT tag) {
        this.playerHats.clear();
        int count = tag.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            PlayerHatData playerData = new PlayerHatData();
            playerData.read(tag.func_74775_l("hats_" + i));
            this.playerHats.put(playerData.owner, playerData);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        tag.func_74768_a("count", this.playerHats.size());
        int i = 0;
        for (Map.Entry<UUID, PlayerHatData> entry : this.playerHats.entrySet()) {
            tag.func_218657_a("hats_" + i, (INBT)entry.getValue().write(new CompoundNBT()));
            ++i;
        }
        return tag;
    }

    public static class HatPart
    implements Comparable<HatPart> {
        @CapabilityInject(value=HatPart.class)
        public static Capability<HatPart> CAPABILITY_INSTANCE;
        public static final ResourceLocation CAPABILITY_IDENTIFIER;
        public String name = "";
        public int count = -1;
        public boolean isFavourite;
        public boolean isNew;
        public boolean isShowing;
        public float[] colouriser = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        public float[] hsbiser = new float[]{0.0f, 0.0f, 0.0f};
        public boolean enchanted = false;
        public ArrayList<HatPart> hatParts = new ArrayList();

        public HatPart() {
        }

        public HatPart(String s) {
            this.name = s;
            this.count = 1;
        }

        public HatPart setNew() {
            this.isNew = true;
            return this;
        }

        public void copy(HatPart part) {
            this.name = part.name;
            this.count = part.count;
            this.isFavourite = part.isFavourite;
            this.isShowing = part.isShowing;
            this.isNew = part.isNew;
            this.colouriser = (float[])part.colouriser.clone();
            this.hsbiser = (float[])part.hsbiser.clone();
            this.enchanted = part.enchanted;
            this.hatParts.clear();
            for (HatPart hatPart : part.hatParts) {
                this.hatParts.add(hatPart.createCopy());
            }
        }

        public HatPart createCopy() {
            HatPart part = new HatPart();
            part.copy(this);
            return part;
        }

        public HatPart createRandom(Random random) {
            HatPart part = new HatPart();
            part.copy(this);
            part.randomize(random);
            return part;
        }

        public HatPart get(HatPart part) {
            if (part.name.equals(this.name)) {
                return this;
            }
            for (HatPart hatPart : this.hatParts) {
                HatPart accPart = hatPart.get(part);
                if (accPart == null) continue;
                return accPart;
            }
            return null;
        }

        public boolean remove(HatPart part) {
            if (this.hatParts.removeIf(hatPart -> part.name.equals(hatPart.name))) {
                return true;
            }
            for (HatPart hatPart2 : this.hatParts) {
                if (!hatPart2.remove(part)) continue;
                return true;
            }
            return false;
        }

        public void randomize(Random random) {
            this.count = 1;
            this.isShowing = true;
            for (int i = this.hatParts.size() - 1; i >= 0; --i) {
                if (!random.nextBoolean()) continue;
                this.hatParts.remove(i);
            }
            for (HatPart hatPart : this.hatParts) {
                hatPart.randomize(random);
            }
        }

        public boolean isAHat() {
            return !this.name.isEmpty() && this.count >= 0;
        }

        public boolean hasNew() {
            boolean newStuff = this.isNew;
            if (!this.isNew) {
                for (HatPart hatPart : this.hatParts) {
                    newStuff |= hatPart.hasNew();
                }
            }
            return newStuff;
        }

        public HatPart setNoNew() {
            this.isNew = false;
            for (HatPart hatPart : this.hatParts) {
                hatPart.setNoNew();
            }
            return this;
        }

        public boolean hasFavourite() {
            boolean hasFav = this.isFavourite;
            if (!this.isFavourite) {
                for (HatPart hatPart : this.hatParts) {
                    hasFav |= hatPart.hasFavourite();
                }
            }
            return hasFav;
        }

        public HatPart setNoFavourite() {
            this.isFavourite = false;
            for (HatPart hatPart : this.hatParts) {
                hatPart.setNoFavourite();
            }
            return this;
        }

        public boolean add(HatPart part) {
            if (!this.name.isEmpty() && this.name.equals(part.name)) {
                this.count += part.count;
                if (this.count > 999999999) {
                    this.count = 999999999;
                } else if (this.count < 0) {
                    this.count = 0;
                }
                this.copyPersonalisation(part);
                ArrayList<HatPart> partParts = new ArrayList<HatPart>(part.hatParts);
                block0: for (HatPart hatPart : this.hatParts) {
                    for (int i = partParts.size() - 1; i >= 0; --i) {
                        if (!hatPart.add(partParts.get(i))) continue;
                        partParts.remove(i);
                        continue block0;
                    }
                }
                for (HatPart newPart : partParts) {
                    if (newPart.count <= 0) continue;
                    newPart.setNew();
                }
                this.hatParts.addAll(partParts);
                return true;
            }
            return false;
        }

        public boolean minusByOne(HatPart part) {
            if (!this.name.isEmpty() && this.name.equals(part.name)) {
                --this.count;
                this.copyPersonalisation(part);
                ArrayList<HatPart> partParts = new ArrayList<HatPart>(part.hatParts);
                block0: for (HatPart hatPart : this.hatParts) {
                    for (int i = partParts.size() - 1; i >= 0; --i) {
                        if (!hatPart.minusByOne(partParts.get(i)) || hatPart.count > 0) continue;
                        partParts.remove(i);
                        continue block0;
                    }
                }
                return true;
            }
            return false;
        }

        public boolean hasFullPart(HatPart part) {
            if (!this.name.isEmpty() && this.name.equals(part.name) && this.count >= part.count) {
                boolean flag = true;
                for (HatPart hatPart : part.hatParts) {
                    boolean has = false;
                    for (HatPart hatPart1 : this.hatParts) {
                        if (!hatPart1.hasFullPart(hatPart)) continue;
                        has = true;
                        break;
                    }
                    if (has) continue;
                    flag = false;
                    break;
                }
                return flag;
            }
            return false;
        }

        public boolean has(@Nonnull String partName) {
            if (this.name.toLowerCase(Locale.ROOT).contains(partName)) {
                return true;
            }
            for (HatPart accessory : this.hatParts) {
                if (!accessory.has(partName)) continue;
                return true;
            }
            return false;
        }

        public void setCountOfAllTo(int count) {
            this.count = count;
            for (HatPart hatPart : this.hatParts) {
                hatPart.setCountOfAllTo(count);
            }
        }

        public void stripIfNameNotInList(ArrayList<String> names) {
            this.hatParts.removeIf(part -> !names.contains(part.name));
            for (HatPart hatPart : this.hatParts) {
                hatPart.stripIfNameNotInList(names);
            }
        }

        public boolean copyPersonalisation(HatPart part) {
            if (this.name.equals(part.name)) {
                this.isFavourite = part.isFavourite;
                this.isNew = part.isNew;
                this.isShowing = part.isShowing;
                this.colouriser = (float[])part.colouriser.clone();
                this.hsbiser = (float[])part.hsbiser.clone();
                this.enchanted = part.enchanted;
                for (HatPart hatPart : this.hatParts) {
                    for (HatPart hatPart1 : part.hatParts) {
                        hatPart.copyPersonalisation(hatPart1);
                    }
                }
                return true;
            }
            return false;
        }

        public void hideAll() {
            this.isShowing = false;
            for (HatPart hatPart : this.hatParts) {
                hatPart.hideAll();
            }
        }

        public int accessoriesUnlocked() {
            int count = 0;
            count += this.hatParts.size();
            for (HatPart hatPart : this.hatParts) {
                count += hatPart.accessoriesUnlocked();
            }
            return count;
        }

        public boolean hasUnlockedAccessory() {
            boolean flag = false;
            for (HatPart hatPart : this.hatParts) {
                if (hatPart.count == 0 && hatPart.hsbiser[2] == 1.0f && !hatPart.hasUnlockedAccessory()) continue;
                flag = true;
                break;
            }
            return flag;
        }

        public void eventDay(int age, float partialTick) {
            if (this.colouriser[0] == 0.0f && this.colouriser[1] == 0.0f && this.colouriser[2] == 0.0f) {
                HatHandler.RAND.setSeed(Math.abs(this.name.hashCode()));
                int ageR = 40 + HatHandler.RAND.nextInt(60);
                int ageG = 40 + HatHandler.RAND.nextInt(60);
                int ageB = 40 + HatHandler.RAND.nextInt(60);
                float offsetR = 180.0f * HatHandler.RAND.nextFloat();
                float offsetG = 180.0f * HatHandler.RAND.nextFloat();
                float offsetB = 180.0f * HatHandler.RAND.nextFloat();
                this.colouriser[0] = (float)Math.sin(Math.toRadians(offsetR + ((float)age + partialTick) / (float)ageR * 360.0f)) * 0.5f + 0.5f;
                this.colouriser[1] = (float)Math.sin(Math.toRadians(offsetG + ((float)age + partialTick) / (float)ageG * 360.0f)) * 0.5f + 0.5f;
                this.colouriser[2] = (float)Math.sin(Math.toRadians(offsetB + ((float)age + partialTick) / (float)ageB * 360.0f)) * 0.5f + 0.5f;
            }
            for (HatPart hatPart : this.hatParts) {
                hatPart.eventDay(age, partialTick);
            }
        }

        public void read(CompoundNBT tag) {
            this.name = tag.func_74779_i("name");
            this.count = tag.func_74762_e("count");
            this.isFavourite = tag.func_74767_n("isFavourite");
            this.isNew = tag.func_74767_n("isNew");
            this.isShowing = tag.func_74767_n("isShowing");
            this.colouriser = new float[]{tag.func_74760_g("clrR"), tag.func_74760_g("clrG"), tag.func_74760_g("clrB"), tag.func_74760_g("clrA")};
            this.hsbiser = new float[]{tag.func_74760_g("hsbH"), tag.func_74760_g("hsbS"), tag.func_74760_g("hsbB")};
            this.enchanted = tag.func_74767_n("enchanted");
            int count = tag.func_74762_e("partCount");
            this.hatParts.clear();
            for (int i = 0; i < count; ++i) {
                CompoundNBT partTag = tag.func_74775_l("part_" + i);
                HatPart part = new HatPart();
                part.read(partTag);
                if (part.name.isEmpty()) continue;
                this.hatParts.add(part);
            }
        }

        public CompoundNBT write(CompoundNBT tag) {
            tag.func_74778_a("name", this.name);
            tag.func_74768_a("count", this.count);
            tag.func_74757_a("isFavourite", this.isFavourite);
            tag.func_74757_a("isNew", this.isNew);
            tag.func_74757_a("isShowing", this.isShowing);
            tag.func_74776_a("clrR", this.colouriser[0]);
            tag.func_74776_a("clrG", this.colouriser[1]);
            tag.func_74776_a("clrB", this.colouriser[2]);
            tag.func_74776_a("clrA", this.colouriser[3]);
            tag.func_74776_a("hsbH", this.hsbiser[0]);
            tag.func_74776_a("hsbS", this.hsbiser[1]);
            tag.func_74776_a("hsbB", this.hsbiser[2]);
            tag.func_74757_a("enchanted", this.enchanted);
            tag.func_74768_a("partCount", this.hatParts.size());
            for (int i = 0; i < this.hatParts.size(); ++i) {
                HatPart part = this.hatParts.get(i);
                tag.func_218657_a("part_" + i, (INBT)part.write(new CompoundNBT()));
            }
            return tag;
        }

        @Override
        public int compareTo(HatPart o) {
            return this.name.compareTo(o.name);
        }

        public HatPart setModifier(HatPart modifier) {
            this.modify(modifier);
            return this;
        }

        public boolean modify(HatPart modifier) {
            if (modifier == this) {
                return true;
            }
            if (this.name.equals(modifier.name)) {
                this.copy(modifier);
                return true;
            }
            for (HatPart hatPart : this.hatParts) {
                if (!hatPart.modify(modifier)) continue;
                return true;
            }
            return false;
        }

        public void removeHiddenChildren() {
            this.hatParts.removeIf(part -> !part.isShowing);
            for (HatPart hatPart : this.hatParts) {
                hatPart.removeHiddenChildren();
            }
        }

        public void setBrightnessZero() {
            this.hsbiser[2] = 1.0f;
            for (HatPart hatPart : this.hatParts) {
                hatPart.setBrightnessZero();
            }
        }

        static {
            CAPABILITY_IDENTIFIER = new ResourceLocation("hats", "capability_hat");
        }

        public static class CapProvider
        implements ICapabilitySerializable<CompoundNBT> {
            private final HatPart hatPart;
            private final LazyOptional<HatPart> optional;

            public CapProvider(HatPart hatPart) {
                this.hatPart = hatPart;
                this.optional = LazyOptional.of(() -> hatPart);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CAPABILITY_INSTANCE) {
                    return this.optional.cast();
                }
                return LazyOptional.empty();
            }

            public CompoundNBT serializeNBT() {
                return this.hatPart.write(new CompoundNBT());
            }

            public void deserializeNBT(CompoundNBT nbt) {
                this.hatPart.read(nbt);
            }
        }
    }

    public static class PlayerHatData {
        public UUID owner;
        public int tokenCount;
        public ArrayList<HatPart> hatParts = new ArrayList();

        public PlayerHatData() {
        }

        public PlayerHatData(UUID owner) {
            this.owner = owner;
        }

        public void read(CompoundNBT tag) {
            this.hatParts.clear();
            this.owner = tag.func_186857_a("owner");
            this.tokenCount = tag.func_74762_e("tokenCount");
            int count = tag.func_74762_e("partCount");
            for (int i = 0; i < count; ++i) {
                CompoundNBT hatTag = tag.func_74775_l("hat_" + i);
                HatPart part = new HatPart();
                part.read(hatTag);
                if (part.name.isEmpty()) continue;
                this.hatParts.add(part);
            }
        }

        public CompoundNBT write(CompoundNBT tag) {
            tag.func_186854_a("owner", this.owner);
            tag.func_74768_a("tokenCount", this.tokenCount);
            tag.func_74768_a("partCount", this.hatParts.size());
            for (int i = 0; i < this.hatParts.size(); ++i) {
                HatPart part = this.hatParts.get(i);
                tag.func_218657_a("hat_" + i, (INBT)part.write(new CompoundNBT()));
            }
            return tag;
        }
    }
}

