/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.HUDHandlerBlocks;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import snownee.jade.Jade;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;

public class HUDHandlerEntities
implements IEntityComponentProvider {
    static final IEntityComponentProvider INSTANCE = new HUDHandlerEntities();

    @Override
    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ((ITaggableList)tooltip).setTag(HUDHandlerBlocks.OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getEntityName(), HUDHandlerEntities.getEntityName(accessor.getEntity()))));
        if (config.get(PluginCore.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(HUDHandlerBlocks.REGISTRY_NAME_TAG, new StringTextComponent(accessor.getEntity().func_200600_R().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static String getEntityName(Entity entity) {
        if (!entity.func_145818_k_() && entity instanceof ItemEntity) {
            return ((ItemEntity)entity).func_92059_d().func_200301_q().getString();
        }
        return entity.func_200200_C_().getString();
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (config.get(PluginCore.CONFIG_SHOW_ENTITY_HEALTH)) {
            this.appendHealth((LivingEntity)accessor.getEntity(), tooltip);
        }
        if (config.get(PluginCore.CONFIG_SHOW_ENTITY_HEALTH)) {
            this.appendArmor((LivingEntity)accessor.getEntity(), tooltip);
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.get(JadePlugin.HIDE_MOD_NAME)) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(accessor.getEntity()))));
    }

    private void appendHealth(LivingEntity living, List<ITextComponent> tooltip) {
        float health = living.func_110143_aJ();
        float maxHealth = living.func_110138_aP();
        if (living.func_110138_aP() > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
            CompoundNBT healthData = new CompoundNBT();
            healthData.func_74776_a("health", 1.0f);
            healthData.func_74776_a("max", 1.0f);
            RenderableTextComponent icon = new RenderableTextComponent(PluginCore.RENDER_ENTITY_HEALTH, healthData);
            RenderableTextComponent text = Renderables.offsetText(String.format("%s/%s", Jade.dfCommas.format(health), Jade.dfCommas.format(maxHealth)), 5, 0);
            tooltip.add((ITextComponent)Renderables.of(new ITextComponent[]{icon, text}));
        } else {
            CompoundNBT healthData = new CompoundNBT();
            healthData.func_74776_a("health", health * 0.5f);
            healthData.func_74776_a("max", maxHealth * 0.5f);
            tooltip.add((ITextComponent)new RenderableTextComponent(PluginCore.RENDER_ENTITY_HEALTH, healthData));
        }
    }

    private void appendArmor(LivingEntity living, List<ITextComponent> tooltip) {
        float armor = living.func_70658_aO();
        if (armor == 0.0f) {
            return;
        }
        if (armor > (float)Waila.CONFIG.get().getGeneral().getMaxHealthForRender()) {
            CompoundNBT armorData = new CompoundNBT();
            armorData.func_74776_a("armor", -1.0f);
            RenderableTextComponent icon = new RenderableTextComponent(PluginCore.RENDER_ENTITY_ARMOR, armorData);
            RenderableTextComponent text = Renderables.offsetText(Jade.dfCommas.format(armor), 5, 0);
            tooltip.add((ITextComponent)Renderables.of(new ITextComponent[]{icon, text}));
        } else {
            CompoundNBT armorData = new CompoundNBT();
            armorData.func_74776_a("armor", armor * 0.5f);
            tooltip.add((ITextComponent)new RenderableTextComponent(PluginCore.RENDER_ENTITY_ARMOR, armorData));
        }
    }
}

