/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.network.MessageReceiveData;
import mcp.mobius.waila.network.MessageRequestTile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestEntity {
    public int entityId;

    public MessageRequestEntity(Entity entity) {
        this.entityId = entity.func_145782_y();
    }

    private MessageRequestEntity(int entityId) {
        this.entityId = entityId;
    }

    public static MessageRequestEntity read(PacketBuffer buffer) {
        return new MessageRequestEntity(buffer.func_150792_a());
    }

    public static void write(MessageRequestEntity message, PacketBuffer buffer) {
        buffer.func_150787_b(message.entityId);
    }

    public static class Handler {
        public static void onMessage(MessageRequestEntity message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                World world = player.field_70170_p;
                Entity entity = world.func_73045_a(message.entityId);
                if (entity == null || player.func_70068_e(entity) > (double)MessageRequestTile.MAX_DISTANCE_SQR) {
                    return;
                }
                CompoundNBT tag = new CompoundNBT();
                if (WailaRegistrar.INSTANCE.hasNBTEntityProviders(entity)) {
                    WailaRegistrar.INSTANCE.getNBTEntityProviders(entity).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, player, world, entity)));
                } else {
                    entity.func_189511_e(tag);
                }
                tag.func_74768_a("WailaEntityID", entity.func_145782_y());
                Waila.NETWORK.sendTo((Object)new MessageReceiveData(tag), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            });
            context.get().setPacketHandled(true);
        }
    }
}

