/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.commons.lang3.StringUtils;

public class ModIdentification {
    public static final Map<String, String> NAMES = Maps.newHashMap();

    public static String getModName(String namespace) {
        return NAMES.getOrDefault(namespace, "Minecraft");
    }

    public static String getModName(ResourceLocation id) {
        return ModIdentification.getModName(id.func_110624_b());
    }

    public static String getModName(Block block) {
        return ModIdentification.getModName(block.getRegistryName());
    }

    public static String getModName(ItemStack stack) {
        return ModIdentification.getModName(stack.func_77973_b().getCreatorModId(stack));
    }

    public static String getModName(Entity entity) {
        PaintingType art;
        if (entity instanceof PaintingEntity && (art = ((PaintingEntity)entity).field_70522_e) != null) {
            return ModIdentification.getModName(art.getRegistryName().func_110624_b());
        }
        if (entity instanceof ItemEntity) {
            return ModIdentification.getModName(((ItemEntity)entity).func_92059_d());
        }
        return ModIdentification.getModName(entity.func_200600_R().getRegistryName());
    }

    static {
        ImmutableList mods = ImmutableList.copyOf((Collection)ModList.get().getMods());
        for (ModInfo mod : mods) {
            String modid = mod.getModId();
            String name = mod.getDisplayName();
            if (Strings.isNullOrEmpty((String)name)) {
                StringUtils.capitalize((String)modid);
            }
            NAMES.put(modid, name);
        }
    }
}

