/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.PasteContainerCapabilityProvider;
import com.direwolf20.buildinggadgets.common.items.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.direwolf20.buildinggadgets.common.util.lang.TooltipTranslation;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ConstructionPasteContainer
extends Item {
    private static final ResourceLocation LEVEL = new ResourceLocation("level");
    private final IntSupplier maxCapacity;
    private final boolean isCreative;

    public ConstructionPasteContainer(boolean isCreative, IntSupplier maxCapacity) {
        super(OurItems.nonStackableItemProperties());
        this.isCreative = isCreative;
        this.maxCapacity = maxCapacity;
    }

    public ConstructionPasteContainer(boolean isCreative) {
        this(isCreative, () -> Integer.MAX_VALUE);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PasteContainerCapabilityProvider(stack);
    }

    public void setPasteCount(ItemStack stack, int amount) {
        if (this.isCreative) {
            return;
        }
        stack.func_196082_o().func_74768_a("amount", amount);
    }

    public int getPasteCount(ItemStack stack) {
        if (this.isCreative) {
            return Integer.MAX_VALUE;
        }
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("amount");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        player.func_184598_c(hand);
        PlayerInventory inv = player.field_71071_by;
        if (!world.field_72995_K) {
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) continue;
                InventoryHelper.addPasteToContainer(player, itemStack);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        TranslationTextComponent key = this.isCreative ? TooltipTranslation.PASTECONTAINER_CREATIVE_AMOUNT.componentTranslation(new Object[0]) : TooltipTranslation.PASTECONTAINER_AMOUNT.componentTranslation(this.getPasteCount(stack), this.getMaxCapacity());
        list.add((ITextComponent)key.func_230530_a_(Styles.WHITE));
    }

    public static void setPasteAmount(ItemStack stack, int amount) {
        Item item = stack.func_77973_b();
        if (item instanceof ConstructionPasteContainer) {
            ((ConstructionPasteContainer)item).setPasteCount(stack, amount);
        } else {
            BuildingGadgets.LOG.warn("Potential abuse of ConstructionPasteContainer#setPasteAmount(ItemStack, int) where the given ItemStack does not contain a ConstructionPasteContainer.");
        }
    }

    public static int getPasteAmount(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ConstructionPasteContainer) {
            return ((ConstructionPasteContainer)item).getPasteCount(stack);
        }
        BuildingGadgets.LOG.warn("Potential abuse of ConstructionPasteContainer#getPasteAmount(ItemStack) where the given ItemStack does not contain a ConstructionPasteContainer.");
        return 0;
    }

    public int getMaxCapacity() {
        return this.isCreative ? Integer.MAX_VALUE : this.maxCapacity.getAsInt();
    }

    public boolean isCreative() {
        return this.isCreative;
    }
}

