/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkIO
implements IItemHandler {
    private final List<ItemStack> stacks;

    protected NetworkIO(Collection<ItemStack> stacks) {
        this.stacks = ImmutableList.copyOf(stacks);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stacks.get(slot);
    }

    @Nullable
    public abstract ItemStack insertItemInternal(ItemStack var1, boolean var2);

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.getNonNullStack(this.insertItemInternal(stack, simulate));
    }

    @Nullable
    public abstract ItemStack extractItemInternal(int var1, int var2, boolean var3);

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getNonNullStack(this.extractItemInternal(slot, amount, simulate));
    }

    private ItemStack getNonNullStack(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public static enum Operation {
        EXTRACT,
        INSERT;

    }
}

