/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Set;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.TagSelectorWindow;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.modules.filter.FilterModule;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleContainer;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolsbase.modules.filter.network.PacketSyncHandItem;
import mcjty.rftoolsbase.modules.filter.network.PacketUpdateNBTItemFilter;
import mcjty.rftoolsbase.setup.RFToolsBaseMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiFilterModule
extends GenericGuiContainer<GenericTileEntity, FilterModuleContainer> {
    public static final int CONTROLLER_WIDTH = 230;
    public static final int CONTROLLER_HEIGHT = 188;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsbase", "textures/gui/filtermodule.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    private final TagSelectorWindow selector = new TagSelectorWindow();
    private ImageChoiceLabel blacklistMode;
    private ImageChoiceLabel damageMode;
    private ImageChoiceLabel nbtMode;
    private ImageChoiceLabel modMode;
    private Button remove;
    private Button expand;
    private WidgetList list;

    public GuiFilterModule(FilterModuleContainer container, PlayerInventory inventory) {
        super(null, (Container)container, inventory, FilterModuleItem.MANUAL);
        this.field_146999_f = 230;
        this.field_147000_g = 188;
    }

    public static void register() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)FilterModule.CONTAINER_FILTER_MODULE.get()), GuiFilterModule::createFilterModuleGui);
    }

    private static GuiFilterModule createFilterModuleGui(FilterModuleContainer container, PlayerInventory inventory, ITextComponent textComponent) {
        return new GuiFilterModule(container, inventory);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.remove = ((Button)Widgets.button((int)5, (int)106, (int)50, (int)15, (String)"Remove").tooltips(new String[]{"Remove current selection"})).event(this::removeSelection);
        this.expand = ((Button)Widgets.button((int)5, (int)121, (int)50, (int)15, (String)"Expand").tooltips(new String[]{"Expand item to tags"})).event(this::expandToTags);
        Button addTags = ((Button)Widgets.button((int)5, (int)137, (int)50, (int)15, (String)"Add tags").tooltips(new String[]{"Add tags"})).event(this::addTagWindow);
        this.blacklistMode = ((ImageChoiceLabel)Widgets.imageChoice((int)5, (int)152, (int)16, (int)16).tooltips(new String[]{"Black or whitelist mode"})).event(newChoice -> this.updateSettings());
        this.blacklistMode.choice("Black", "Blacklist items", guiElements, 224, 32);
        this.blacklistMode.choice("White", "Whitelist items", guiElements, 240, 32);
        this.damageMode = ((ImageChoiceLabel)Widgets.imageChoice((int)21, (int)152, (int)16, (int)16).tooltips(new String[]{"Filter ignoring damage"})).event(newChoice -> this.updateSettings());
        this.damageMode.choice("Off", "Ignore damage", guiElements, 96, 32);
        this.damageMode.choice("On", "Damage must match", guiElements, 112, 32);
        this.nbtMode = ((ImageChoiceLabel)Widgets.imageChoice((int)5, (int)168, (int)16, (int)16).tooltips(new String[]{"Filter ignoring NBT"})).event(newChoice -> this.updateSettings());
        this.nbtMode.choice("Off", "Ignore NBT", guiElements, 128, 32);
        this.nbtMode.choice("On", "NBT must match", guiElements, 144, 32);
        this.modMode = ((ImageChoiceLabel)Widgets.imageChoice((int)21, (int)168, (int)16, (int)16).tooltips(new String[]{"Filter ignoring mod"})).event(newChoice -> this.updateSettings());
        this.modMode.choice("Off", "Don't match on mod", guiElements, 192, 32);
        this.modMode.choice("On", "Only mod must match", guiElements, 208, 32);
        this.list = (WidgetList)Widgets.list((int)5, (int)4, (int)207, (int)99).name("list");
        Slider slider = Widgets.slider((int)212, (int)4, (int)10, (int)99).scrollableName("list");
        CompoundNBT tagCompound = Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77978_p();
        if (tagCompound != null) {
            this.setBlacklistMode(tagCompound.func_74779_i("blacklistMode"));
            this.damageMode.setCurrentChoice(tagCompound.func_74767_n("damageMode") ? 1 : 0);
            this.nbtMode.setCurrentChoice(tagCompound.func_74767_n("nbtMode") ? 1 : 0);
            this.modMode.setCurrentChoice(tagCompound.func_74767_n("modMode") ? 1 : 0);
        } else {
            this.setBlacklistMode("White");
        }
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.blacklistMode, this.damageMode, this.nbtMode, this.modMode, this.list, slider, this.remove, this.expand, addTags});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.fillList();
    }

    private void addTagWindow() {
        this.selector.create(this.window, "both", t -> {
            if (t != null) {
                FilterModuleInventory inventory = new FilterModuleInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                inventory.addTag(new ResourceLocation(t));
                inventory.markDirty();
                this.refresh();
            }
        }, () -> null, true);
    }

    private void refresh() {
        this.syncStack();
        this.fillList();
    }

    private void expandToTags() {
        if (!this.canExpand()) {
            return;
        }
        FilterModuleInventory inventory = new FilterModuleInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        ItemStack stack = inventory.getStacks().get(this.list.getSelected() - inventory.getTags().size());
        Set tags = stack.func_77973_b().getTags();
        if (tags.isEmpty()) {
            return;
        }
        this.removeSelection();
        inventory = new FilterModuleInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        for (ResourceLocation tag : tags) {
            inventory.addTag(tag);
        }
        inventory.markDirty();
        this.refresh();
    }

    private void removeSelection() {
        if (!this.canRemove()) {
            return;
        }
        FilterModuleInventory inventory = new FilterModuleInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (this.list.getSelected() >= inventory.getTags().size()) {
            inventory.removeStack(this.list.getSelected() - inventory.getTags().size());
        } else {
            inventory.removeTag((ResourceLocation)this.list.getChild(this.list.getSelected()).getUserObject());
        }
        inventory.markDirty();
        this.refresh();
    }

    protected void drawWindow(MatrixStack matrixStack) {
        super.drawWindow(matrixStack);
        this.remove.enabled(this.canRemove());
        this.expand.enabled(this.canExpand());
    }

    private boolean canRemove() {
        return this.list.getSelected() != -1;
    }

    private boolean canExpand() {
        return this.list.getSelected() != -1 && this.list.getChild(this.list.getSelected()).getUserObject() == null;
    }

    private void fillList() {
        FilterModuleInventory inventory = new FilterModuleInventory((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.list.removeChildren();
        for (ResourceLocation tag : inventory.getTags()) {
            ITag itemTag = ItemTags.func_199903_a().func_199910_a(tag);
            if (itemTag != null) {
                this.addTagToList(itemTag, tag);
                continue;
            }
            ITag blockTag = BlockTags.func_199896_a().func_199910_a(tag);
            if (blockTag == null) continue;
            this.addTagToList(blockTag, tag);
        }
        for (ItemStack stack : inventory.getStacks()) {
            Panel panel = Widgets.horizontal();
            BlockRender render = new BlockRender().renderItem((Object)stack);
            panel.children(new Widget[]{render});
            String formattedText = stack.func_200301_q().getString();
            if (formattedText.length() >= 30) {
                formattedText = formattedText.substring(0, 28) + "...";
            }
            panel.children(new Widget[]{Widgets.label((String)formattedText)});
            this.list.children(new Widget[]{panel});
        }
    }

    private <T extends IItemProvider> void addTagToList(ITag<T> tag, ResourceLocation id) {
        Panel panel = Widgets.horizontal((int)0, (int)0);
        panel.userObject((Object)id);
        panel.children(new Widget[]{((Label)Widgets.label((String)id.toString()).desiredWidth(120)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
        int i = 5;
        for (IItemProvider item : tag.func_230236_b_()) {
            BlockRender render = new BlockRender().renderItem((Object)new ItemStack(item));
            panel.children(new Widget[]{render});
            if (--i > 0) continue;
            break;
        }
        this.list.children(new Widget[]{panel});
    }

    private void setBlacklistMode(String mode) {
        int idx = this.blacklistMode.findChoice(mode);
        if (idx == -1) {
            this.blacklistMode.setCurrentChoice("Black");
        } else {
            this.blacklistMode.setCurrentChoice(idx);
        }
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && !slotIn.func_75211_c().func_190926_b()) {
            FilterModuleInventory inventory = new FilterModuleInventory((PlayerEntity)this.field_230706_i_.field_71439_g);
            if (McJtyLib.proxy.isSneaking()) {
                for (ResourceLocation tag : slotIn.func_75211_c().func_77973_b().getTags()) {
                    inventory.addTag(tag);
                }
            } else {
                inventory.addStack(slotIn.func_75211_c());
            }
            inventory.markDirty();
            this.refresh();
        }
    }

    public List<ITextComponent> func_231151_a_(ItemStack p_231151_1_) {
        List list = super.func_231151_a_(p_231151_1_);
        list.add(new StringTextComponent(TextFormatting.GOLD + "Click to add to filter"));
        list.add(new StringTextComponent(TextFormatting.GOLD + "Shift-Click to add tags to filter"));
        return list;
    }

    private void syncStack() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketSyncHandItem((PlayerEntity)this.field_230706_i_.field_71439_g));
    }

    private void updateSettings() {
        RFToolsBaseMessages.INSTANCE.sendToServer((Object)new PacketUpdateNBTItemFilter(TypedMap.builder().put(new Key("blacklistMode", Type.STRING), (Object)this.blacklistMode.getCurrentChoice()).put(new Key("damageMode", Type.BOOLEAN), (Object)(this.damageMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("modMode", Type.BOOLEAN), (Object)(this.modMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(new Key("nbtMode", Type.BOOLEAN), (Object)(this.nbtMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build()));
    }
}

