/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.items;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipExtras;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.modules.filter.FilterModuleCache;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleContainer;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleInventory;
import mcjty.rftoolsbase.tools.ManualHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;

public class FilterModuleItem
extends Item
implements ITooltipSettings,
ITooltipExtras {
    public static final ManualEntry MANUAL = ManualHelper.create("rftoolsbase:tools/filtermodule");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbase.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> {
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            String blackListMode = tagCompound.func_74779_i("blacklistMode");
            String modeLine = "Mode " + ("Black".equals(blackListMode) ? "blacklist" : "whitelist");
            if (tagCompound.func_74767_n("damageMode")) {
                modeLine = modeLine + ", Damage";
            }
            if (tagCompound.func_74767_n("nbtMode")) {
                modeLine = modeLine + ", NBT";
            }
            if (tagCompound.func_74767_n("modMode")) {
                modeLine = modeLine + ", Mod";
            }
            return modeLine;
        }
        return "<not configured>";
    })});

    public FilterModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(RFToolsBase.setup.getTab()));
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, list, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flagIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        ItemStack stack = player.func_184586_b(hand);
        BlockPos pos = context.func_195995_a();
        if (player.func_213453_ef()) {
            if (!world.field_72995_K) {
                TileEntity te = world.func_175625_s(pos);
                if (InventoryTools.isInventory((TileEntity)te)) {
                    FilterModuleInventory inventory = new FilterModuleInventory(stack);
                    InventoryTools.getItems((TileEntity)te, s -> true).forEach(inventory::addStack);
                    inventory.markDirty();
                    player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Stored inventory contents in filter"), false);
                } else {
                    BlockState state = world.func_180495_p(pos);
                    ItemStack blockStack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
                    if (!blockStack.func_190926_b()) {
                        FilterModuleInventory inventory = new FilterModuleInventory(stack);
                        inventory.addStack(blockStack);
                        inventory.markDirty();
                        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Added " + blockStack.func_200301_q().getString() + " to the filter!"), false);
                    } else {
                        player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Could not add " + blockStack.func_200301_q().getString() + " to the filter!"), false);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Filter Module");
                }

                public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                    FilterModuleContainer container = new FilterModuleContainer(id, player.func_233580_cy_(), player);
                    container.setupInventories(null, playerInventory);
                    return container;
                }
            });
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static Predicate<ItemStack> getCache(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new FilterModuleCache(stack);
    }

    public List<Pair<ItemStack, Integer>> getItems(ItemStack stack) {
        FilterModuleInventory inventory = new FilterModuleInventory(stack);
        HashSet<Item> itemSet = new HashSet<Item>();
        for (ItemStack s : inventory.getStacks()) {
            itemSet.add(s.func_77973_b());
        }
        for (ResourceLocation tag : inventory.getTags()) {
            ITag itemTag = ItemTags.func_199903_a().func_199910_a(tag);
            if (itemTag != null) {
                itemSet.addAll(itemTag.func_230236_b_());
                continue;
            }
            ITag blockTag = BlockTags.func_199896_a().func_199910_a(tag);
            if (blockTag == null) continue;
            for (Block block : blockTag.func_230236_b_()) {
                itemSet.add(block.func_199767_j());
            }
        }
        return itemSet.stream().map(item -> Pair.of((Object)new ItemStack((IItemProvider)item), (Object)-2)).collect(Collectors.toList());
    }
}

