/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.DimensionId;

public class TickOrderHandler {
    private static Map<DimensionId, List<IOrderTicker>[]> tiles = new HashMap<DimensionId, List<IOrderTicker>[]>();
    private static long ticker = 0L;

    public static void clean() {
        tiles.clear();
    }

    public static long getTicker() {
        return ticker;
    }

    public static void queue(IOrderTicker tile) {
        if (!tiles.containsKey(tile.getDimension())) {
            List[] list = new List[Rank.values().length];
            for (Rank rank : Rank.values()) {
                list[rank.ordinal()] = new ArrayList();
            }
            tiles.put(tile.getDimension(), list);
        }
        tiles.get(tile.getDimension())[tile.getRank().ordinal()].add(tile);
    }

    private static <T extends IOrderTicker> void tickServer(List<T> tileEntities) {
        for (IOrderTicker tileEntity : tileEntities) {
            tileEntity.tickServer();
        }
        tileEntities.clear();
    }

    public static void postWorldTick(DimensionId dimension) {
        ++ticker;
        List<IOrderTicker>[] lists = tiles.get(dimension);
        if (lists != null) {
            for (Rank rank : Rank.values()) {
                TickOrderHandler.tickServer(lists[rank.ordinal()]);
            }
        }
    }

    public static interface IOrderTicker {
        public Rank getRank();

        public void tickServer();

        public DimensionId getDimension();
    }

    public static enum Rank {
        RANK_0,
        RANK_1,
        RANK_2,
        RANK_3,
        RANK_4;

    }
}

