/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.function.impl;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXRenderOffsetFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class RenderOffsetNoisePlane
implements VFXRenderOffsetFunction<EntityVisualFX> {
    private static final String KEY_PLANE_DATA = "plane";
    private static final Random T_RAND = new Random();
    private static final int SAMPLE_TIME_MIN = 35;
    private static final int SAMPLE_TIME_MAX = 55;
    private long lastSample;
    private long targetSample;
    private final float ringSize;
    private Vector3 prevRotationDeg;
    private Vector3 rotationDeg;

    public RenderOffsetNoisePlane(float ringSizeDiameter) {
        this.ringSize = ringSizeDiameter;
        this.buildRotations();
        this.lastSample = ClientScheduler.getClientTick() - (long)this.randomSampleTime();
        this.targetSample = this.lastSample + (long)this.randomSampleTime();
    }

    public FXFacingParticle createParticle(Vector3 position) {
        FXFacingParticle p = (FXFacingParticle)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(position)).color(VFXColorFunction.WHITE)).renderOffset(this);
        p.getOrCreateData(KEY_PLANE_DATA, () -> new PlanarRotationData(T_RAND.nextFloat() * 360.0f, this.ringSize * 0.9f + T_RAND.nextFloat() * this.ringSize * 0.2f));
        return p;
    }

    private Vector3 getCurrentRotationDegree(float partial) {
        this.checkRotations();
        long current = ClientScheduler.getClientTick();
        double perc = 1.0 - (double)((float)(this.targetSample - current) - partial) / (double)(this.targetSample - this.lastSample);
        return this.interpolateRotation(perc, this.prevRotationDeg, this.rotationDeg);
    }

    private void checkRotations() {
        if (ClientScheduler.getClientTick() >= this.targetSample) {
            this.buildRotations();
        }
    }

    private void buildRotations() {
        this.lastSample = ClientScheduler.getClientTick();
        this.prevRotationDeg = this.rotationDeg != null ? this.rotationDeg : Vector3.positiveYRandom();
        this.rotationDeg = Vector3.positiveYRandom();
        this.targetSample = this.lastSample + (long)this.randomSampleTime();
    }

    private int randomSampleTime() {
        return T_RAND.nextInt(55);
    }

    private Vector3 interpolateRotation(double partial, Vector3 vZero, Vector3 vOne) {
        double v = 20.0 * MathHelper.func_151237_a((double)partial, (double)0.0, (double)1.0) - 10.0;
        v = MathHelper.func_151237_a((double)(Math.atan(v) / 2.9423 + 0.5), (double)0.0, (double)1.0);
        return this.getInterpolatedVectorRotation((float)v, vZero, vOne);
    }

    private Vector3 getInterpolatedVectorRotation(float percent, Vector3 vZero, Vector3 vOne) {
        return new Vector3(RenderingVectorUtils.interpolate(vZero.getX(), vOne.getX(), percent), RenderingVectorUtils.interpolate(vZero.getY(), vOne.getY(), percent), RenderingVectorUtils.interpolate(vZero.getZ(), vOne.getZ(), percent));
    }

    @Override
    @Nonnull
    public Vector3 changeRenderPosition(@Nonnull EntityVisualFX fx, Vector3 interpolatedPos, float pTicks) {
        PlanarRotationData data = (PlanarRotationData)fx.getData(KEY_PLANE_DATA);
        if (data == null) {
            return interpolatedPos;
        }
        Vector3 angle = this.getCurrentRotationDegree(pTicks);
        Vector3 v = angle.clone().perpendicular().normalize().multiply(data.initialDistance);
        v.rotate(Math.toRadians(data.degreeRotation), angle);
        return interpolatedPos.add(v);
    }

    private static class PlanarRotationData {
        private final float degreeRotation;
        private final float initialDistance;

        private PlanarRotationData(float degreeRotation, float initialDistance) {
            this.degreeRotation = degreeRotation;
            this.initialDistance = initialDistance;
        }
    }
}

