/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityDynamicFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.render.IDrawRenderTypeBuffer;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.resource.BlockAtlasTexture;
import hellfirepvp.astralsorcery.client.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.client.util.RenderTypeDecorator;
import java.awt.Color;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Tuple;

public class FXSpritePlane
extends EntityVisualFX
implements EntityDynamicFX {
    private float lastRenderDegree = 0.0f;
    private Vector3 axis = Vector3.RotAxis.Y_AXIS;
    private int ticksPerFullRot = 100;
    private float fixDegree = 0.0f;
    private float spriteDisplayFactor = 1.0f;
    private SpriteSheetResource sprite = null;

    public FXSpritePlane(Vector3 pos) {
        super(pos);
    }

    public FXSpritePlane setSprite(AbstractRenderableTexture tex) {
        return this.setSprite(new SpriteSheetResource(tex));
    }

    public FXSpritePlane setSprite(SpriteSheetResource sprite) {
        this.sprite = sprite;
        return this;
    }

    public FXSpritePlane setSpriteDisplayFactor(float spriteDisplayFactor) {
        this.spriteDisplayFactor = spriteDisplayFactor;
        return this;
    }

    public FXSpritePlane setAxis(Vector3 axis) {
        this.axis = axis.clone();
        return this;
    }

    public FXSpritePlane setTicksPerFullRotation(int ticksPerFullRot) {
        this.ticksPerFullRot = ticksPerFullRot;
        return this;
    }

    public FXSpritePlane setNoRotation(float fixedDregree) {
        this.ticksPerFullRot = -1;
        this.fixDegree = fixedDregree;
        return this;
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
    }

    @Override
    public <T extends EntityVisualFX> void renderNow(BatchRenderContext<T> ctx, MatrixStack renderStack, IDrawRenderTypeBuffer drawBuffer, float pTicks) {
        float deg;
        SpriteSheetResource ssr = this.sprite != null ? this.sprite : ctx.getSprite();
        Tuple<Float, Float> uvOffset = ssr.getUVOffset(this, pTicks, this.spriteDisplayFactor);
        Vector3 vec = this.getRenderPosition(pTicks);
        vec.subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
        float scale = this.getScale(pTicks);
        int alpha = this.getAlpha(pTicks);
        Color color = this.getColor(pTicks);
        Vector3 axis = this.axis.clone();
        if (this.ticksPerFullRot >= 0) {
            float anglePercent = (float)this.getAge() / (float)this.ticksPerFullRot;
            deg = anglePercent * 360.0f;
            this.lastRenderDegree = deg = RenderingVectorUtils.interpolateRotation(this.lastRenderDegree, deg, pTicks);
        } else {
            deg = this.fixDegree;
        }
        RenderTypeDecorator decorated = RenderTypeDecorator.wrapSetup((RenderType)ctx.getRenderType(), ssr::bindTexture, () -> BlockAtlasTexture.getInstance().bindTexture());
        IVertexBuilder buf = drawBuffer.getBuffer((RenderType)decorated);
        RenderingDrawUtils.renderAngleRotatedTexturedRectVB(buf, renderStack, vec, axis, (float)Math.toRadians(deg), scale, ((Float)uvOffset.func_76341_a()).floatValue(), ((Float)uvOffset.func_76340_b()).floatValue(), ssr.getULength(), ssr.getVLength(), color.getRed(), color.getGreen(), color.getBlue(), alpha);
        drawBuffer.draw();
    }
}

