/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.TileEntityScreen;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravedStarMap;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktEngraveGlass;
import hellfirepvp.astralsorcery.common.tile.TileRefractionTable;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ScreenRefractionTable
extends TileEntityScreen<TileRefractionTable> {
    private static final Rectangle PLACEMENT_GRID = new Rectangle(98, 75, 60, 60);
    private final Map<Rectangle, IConstellation> mapRenderedConstellations = new HashMap<Rectangle, IConstellation>();
    private final List<DrawnConstellation> currentlyDrawnConstellations = new ArrayList<DrawnConstellation>();
    private IConstellation dragging = null;

    public ScreenRefractionTable(TileRefractionTable tile) {
        super(tile, 188, 256);
    }

    public void func_230430_a_(MatrixStack renderStack, int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableDepthTest();
        super.func_230430_a_(renderStack, mouseX, mouseY, pTicks);
        this.mapRenderedConstellations.clear();
        if (((TileRefractionTable)this.getTile()).hasParchment()) {
            this.drawWHRect(renderStack, TexturesAS.TEX_GUI_REFRACTION_TABLE_PARCHMENT);
        } else {
            this.drawWHRect(renderStack, TexturesAS.TEX_GUI_REFRACTION_TABLE_EMPTY);
        }
        if ((double)DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w()) <= 0.05 || !((TileRefractionTable)this.getTile()).hasParchment()) {
            this.currentlyDrawnConstellations.clear();
            this.dragging = null;
        }
        ArrayList<ITextProperties> tooltip = new ArrayList<ITextProperties>();
        FontRenderer tooltipRenderer = Minecraft.func_71410_x().field_71466_p;
        tooltipRenderer = this.renderTileItems(renderStack, mouseX, mouseY, tooltip, tooltipRenderer);
        this.renderConstellationOptions(renderStack, mouseX, mouseY, tooltip);
        this.renderRunningHalo(renderStack);
        this.renderInputItem(renderStack);
        this.renderDrawnConstellations(renderStack, mouseX, mouseY, tooltip);
        this.renderDraggedConstellations(renderStack);
        this.renderDragging(renderStack, mouseX, mouseY);
        if (!tooltip.isEmpty()) {
            this.func_230926_e_(510);
            RenderingDrawUtils.renderBlueTooltipComponents(renderStack, mouseX, mouseY, this.getGuiZLevel(), tooltip, tooltipRenderer, true);
            this.func_230926_e_(0);
        }
    }

    private void renderDragging(MatrixStack renderStack, int mouseX, int mouseY) {
        if (this.dragging == null) {
            return;
        }
        int whDrawn = 30;
        Point offset = new Point(mouseX, mouseY);
        offset.translate(-whDrawn, -whDrawn);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderingConstellationUtils.renderConstellationIntoGUI(this.dragging, renderStack, offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.4f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w())), true, false);
        RenderSystem.disableBlend();
        this.renderBox(renderStack, offset.x, offset.y, whDrawn * 2, whDrawn * 2, this.dragging.getTierRenderColor());
        Rectangle r = new Rectangle(PLACEMENT_GRID);
        r.grow(30, 30);
        r.translate(this.guiLeft, this.guiTop);
        this.renderBox(renderStack, r.x, r.y, r.width, r.height, this.dragging.getTierRenderColor());
    }

    private void renderDraggedConstellations(MatrixStack renderStack) {
        int whDrawn = 30;
        for (DrawnConstellation dragged : this.currentlyDrawnConstellations) {
            Point offset = new Point(dragged.getPoint());
            offset.translate(this.guiLeft, this.guiTop);
            offset.translate(ScreenRefractionTable.PLACEMENT_GRID.x, ScreenRefractionTable.PLACEMENT_GRID.y);
            offset.translate(-whDrawn, -whDrawn);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(dragged.getConstellation(), renderStack, offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.4f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(((TileRefractionTable)this.getTile()).func_145831_w())), true, false);
            RenderSystem.disableBlend();
        }
    }

    private void renderInputItem(MatrixStack renderStack) {
        if (((TileRefractionTable)this.getTile()).getInputStack().func_190926_b() || ((TileRefractionTable)this.getTile()).hasParchment()) {
            return;
        }
        this.func_230926_e_(100);
        ItemStack input = ((TileRefractionTable)this.getTile()).getInputStack();
        RenderSystem.disableDepthTest();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)(this.guiLeft + 63) + 16.25, (double)(this.guiTop + 42) + 16.25, (double)this.getGuiZLevel());
        renderStack.func_227862_a_(6.0f, 6.0f, 1.0f);
        RenderingUtils.renderItemStackGUI(renderStack, input, null);
        renderStack.func_227865_b_();
        RenderSystem.enableDepthTest();
        this.func_230926_e_(0);
    }

    private void renderRunningHalo(MatrixStack renderStack) {
        if (!(((TileRefractionTable)this.getTile()).getRunProgress() > 0.0f)) {
            return;
        }
        SpritesAS.SPR_HALO_INFUSION.bindTexture();
        Tuple<Float, Float> uvFrame = SpritesAS.SPR_HALO_INFUSION.getUVOffset(ClientScheduler.getClientTick());
        float scale = 160.0f;
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.disableAlphaTest();
        renderStack.func_227860_a_();
        renderStack.func_227861_a_((double)((float)this.guiWidth / 2.0f), (double)((float)this.guiHeight / 2.0f), 0.0);
        renderStack.func_227862_a_(-scale / 2.0f, -scale / 2.0f, 1.0f);
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect((IVertexBuilder)buf, renderStack, this).dim(scale, scale).color(1.0f, 1.0f, 1.0f, ((TileRefractionTable)this.getTile()).getRunProgress()).tex(((Float)uvFrame.func_76341_a()).floatValue(), ((Float)uvFrame.func_76340_b()).floatValue(), SpritesAS.SPR_HALO_INFUSION.getUWidth(), SpritesAS.SPR_HALO_INFUSION.getVWidth()).draw());
        renderStack.func_227865_b_();
        RenderSystem.enableAlphaTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
    }

    private void renderDrawnConstellations(MatrixStack renderStack, int mouseX, int mouseY, List<ITextProperties> tooltip) {
        ItemStack glass = ((TileRefractionTable)this.getTile()).getGlassStack();
        if (glass.func_190926_b()) {
            return;
        }
        World world = ((TileRefractionTable)this.getTile()).func_145831_w();
        float nightPerc = DayTimeHelper.getCurrentDaytimeDistribution(world);
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
        if (ctx == null || !((TileRefractionTable)this.getTile()).doesSeeSky() || nightPerc <= 0.05f) {
            return;
        }
        EngravedStarMap map = ItemInfusedGlass.getEngraving(glass);
        if (map == null) {
            return;
        }
        for (DrawnConstellation cst : map.getDrawnConstellations()) {
            int whDrawn = 30;
            Point offset = new Point(cst.getPoint());
            offset.translate(this.guiLeft, this.guiTop);
            offset.translate(ScreenRefractionTable.PLACEMENT_GRID.x, ScreenRefractionTable.PLACEMENT_GRID.y);
            offset.translate(-whDrawn, -whDrawn);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(cst.getConstellation(), renderStack, offset.x, offset.y, this.getGuiZLevel(), whDrawn * 2, whDrawn * 2, 1.6f, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(world) * 0.8f), true, false);
            RenderSystem.disableBlend();
        }
    }

    private void renderConstellationOptions(MatrixStack renderStack, int mouseX, int mouseY, List<ITextProperties> tooltip) {
        ItemStack glass = ((TileRefractionTable)this.getTile()).getGlassStack();
        if (glass.func_190926_b()) {
            return;
        }
        World world = ((TileRefractionTable)this.getTile()).func_145831_w();
        float nightPerc = DayTimeHelper.getCurrentDaytimeDistribution(world);
        WorldContext ctx = SkyHandler.getContext(world, LogicalSide.CLIENT);
        if (ctx == null || !((TileRefractionTable)this.getTile()).doesSeeSky() || nightPerc <= 0.05f) {
            return;
        }
        List cstList = ctx.getActiveCelestialsHandler().getActiveConstellations().stream().filter(c -> ResearchHelper.getClientProgress().hasConstellationDiscovered((IConstellation)c)).collect(Collectors.toList());
        for (int i = 0; i < Math.min(cstList.size(), 12); ++i) {
            IConstellation cst = (IConstellation)cstList.get(i);
            int offsetX = this.guiLeft + (i % 2 == 0 ? 8 : 232);
            int offsetY = this.guiTop + (40 + i / 2 * 23);
            Rectangle rct = new Rectangle(offsetX, offsetY, 16, 16);
            this.mapRenderedConstellations.put(rct, cst);
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            RenderingConstellationUtils.renderConstellationIntoGUI(Color.WHITE, cst, renderStack, offsetX, offsetY, this.getGuiZLevel(), 16.0f, 16.0f, 0.5, () -> Float.valueOf(DayTimeHelper.getCurrentDaytimeDistribution(world)), true, false);
            RenderSystem.disableBlend();
            if (!rct.contains(mouseX, mouseY)) continue;
            tooltip.add((ITextProperties)cst.getConstellationName());
        }
    }

    private FontRenderer renderTileItems(MatrixStack renderStack, int mouseX, int mouseY, List<ITextProperties> tooltip, FontRenderer tooltipRenderer) {
        ItemStack glass;
        this.func_230926_e_(100);
        ItemStack input = ((TileRefractionTable)this.getTile()).getInputStack();
        if (!input.func_190926_b()) {
            Rectangle itemRct = new Rectangle(this.guiLeft + 111, this.guiTop + 8, 16, 16);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)itemRct.x, (double)itemRct.y, (double)this.getGuiZLevel());
            RenderingUtils.renderItemStackGUI(renderStack, input, null);
            renderStack.func_227865_b_();
            if (itemRct.contains(mouseX, mouseY)) {
                FontRenderer custom = input.func_77973_b().getFontRenderer(input);
                if (custom != null) {
                    tooltipRenderer = custom;
                }
                tooltip.addAll(input.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
            }
        }
        if (!(glass = ((TileRefractionTable)this.getTile()).getGlassStack()).func_190926_b()) {
            Rectangle itemRct = new Rectangle(this.guiLeft + 129, this.guiTop + 8, 16, 16);
            renderStack.func_227860_a_();
            renderStack.func_227861_a_((double)itemRct.x, (double)itemRct.y, (double)this.getGuiZLevel());
            RenderingUtils.renderItemStackGUI(renderStack, glass, null);
            renderStack.func_227865_b_();
            if (itemRct.contains(mouseX, mouseY)) {
                FontRenderer custom = glass.func_77973_b().getFontRenderer(glass);
                if (custom != null) {
                    tooltipRenderer = custom;
                }
                tooltip.addAll(glass.func_82840_a((PlayerEntity)this.getMinecraft().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)));
            }
        }
        this.func_230926_e_(0);
        return tooltipRenderer;
    }

    private void renderBox(MatrixStack renderStack, float offsetX, float offsetY, float width, float height, Color c) {
        Random rand = new Random(18L);
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        Supplier<Float> alpha = () -> Float.valueOf(0.1f + 0.4f * ((MathHelper.func_76126_a((float)((float)rand.nextInt(200) + (float)ClientScheduler.getClientTick() / 20.0f)) + 1.0f) / 2.0f));
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        RenderSystem.disableAlphaTest();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderingUtils.draw(1, DefaultVertexFormats.field_181706_f, buf -> {
            Matrix4f offset = renderStack.func_227866_c_().func_227870_a_();
            buf.func_227888_a_(offset, offsetX, offsetY, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX + width, offsetY, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX + width, offsetY, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX + width, offsetY + height, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX + width, offsetY + height, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX, offsetY + height, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX, offsetY + height, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
            buf.func_227888_a_(offset, offsetX, offsetY, 0.0f).func_227885_a_(r, g, b, ((Float)alpha.get()).floatValue()).func_181675_d();
        });
        RenderSystem.enableDepthTest();
        RenderSystem.enableTexture();
        RenderSystem.enableAlphaTest();
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.currentlyDrawnConstellations.size() >= 3) {
            ArrayList<DrawnConstellation> copyList = new ArrayList<DrawnConstellation>(this.currentlyDrawnConstellations);
            PktEngraveGlass engraveGlass = new PktEngraveGlass((RegistryKey<World>)((TileRefractionTable)this.getTile()).func_145831_w().func_234923_W_(), ((TileRefractionTable)this.getTile()).func_174877_v(), copyList);
            PacketChannel.CHANNEL.sendToServer(engraveGlass);
            this.currentlyDrawnConstellations.clear();
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (super.func_231044_a_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.dragging == null && ((TileRefractionTable)this.getTile()).hasParchment() && ((TileRefractionTable)this.getTile()).hasUnengravedGlass() && this.currentlyDrawnConstellations.size() < 3) {
            this.tryPick(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int click) {
        if (super.func_231048_c_(mouseX, mouseY, click)) {
            return true;
        }
        if (click == 0 && this.dragging != null && ((TileRefractionTable)this.getTile()).hasParchment() && ((TileRefractionTable)this.getTile()).hasUnengravedGlass() && this.currentlyDrawnConstellations.size() < 3) {
            this.tryDrop(mouseX, mouseY);
        }
        return false;
    }

    private void tryDrop(double mouseX, double mouseY) {
        if (this.dragging != null) {
            if (PLACEMENT_GRID.contains(mouseX - (double)this.guiLeft, mouseY - (double)this.guiTop)) {
                Point gridPoint = new Point((int)Math.round(mouseX), (int)Math.round(mouseY));
                gridPoint.translate(-this.guiLeft, -this.guiTop);
                gridPoint.translate(-ScreenRefractionTable.PLACEMENT_GRID.x, -ScreenRefractionTable.PLACEMENT_GRID.y);
                this.currentlyDrawnConstellations.add(new DrawnConstellation(gridPoint, this.dragging));
            }
            this.dragging = null;
        }
    }

    private void tryPick(double mouseX, double mouseY) {
        for (Rectangle r : this.mapRenderedConstellations.keySet()) {
            if (!r.contains(mouseX, mouseY)) continue;
            this.dragging = this.mapRenderedConstellations.get(r);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }
}

